% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceFunctions.R
\name{IncMatAStri}
\alias{IncMatAStri}
\title{Incidence matrix for Arc Slice Proximity Catch Digraphs (AS-PCDs) - one triangle case}
\usage{
IncMatAStri(Xp, tri, M = "CC")
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of AS-PCD.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{M}{The center of the triangle. \code{"CC"} stands for circumcenter of the triangle \code{tri} or a 2D point in Cartesian coordinates or
a 3D point in barycentric coordinates which serves as a center in the interior of \code{tri};
default is \code{M="CC"} i.e., the circumcenter of \code{tri}.}
}
\value{
Incidence matrix for the AS-PCD whose vertices are 2D data set, \code{Xp},
and AS proximity regions are defined with respect to the triangle \code{tri} and
vertex regions based on circumcenter.
}
\description{
Returns the incidence matrix for the AS-PCD whose vertices are the given 2D numerical data set, \code{Xp}.

AS proximity regions are defined with respect to the triangle \code{tri}\eqn{=T(v=1,v=2,v=3)} and
vertex regions based on the center \code{M="CC"} for circumcenter of \code{tri};
or \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the
interior of the triangle \code{tri}; default is \code{M="CC"} i.e., circumcenter of \code{tri}.
Loops are allowed, so the diagonal entries are all equal to 1.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10

set.seed(1)
Xp<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.2)

IM<-IncMatAStri(Xp,Tr,M)
IM

dom.greedy(IM)
dom.exact(IM)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IncMatAS}}, \code{\link{IncMatPEtri}}, and \code{\link{IncMatCStri}}
}
\author{
Elvan Ceyhan
}
