% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{TSArcDensPEint}
\alias{TSArcDensPEint}
\title{A test of uniformity of 1D data in a given interval based on Proportional Edge Proximity Catch Digraph
(PE-PCD)}
\usage{
TSArcDensPEint(
  Xp,
  int,
  r,
  c = 0.5,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)
}
\arguments{
\item{Xp}{A set or \code{vector} of 1D points which constitute the vertices of PE-PCD.}

\item{int}{A \code{vector} of two real numbers representing an interval.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \code{int}\eqn{=(a,b)}
with the default \code{c=.5}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}.}

\item{conf.level}{Level of the confidence interval, default is \code{0.95}, for the arc density of PE-PCD based on
the 1D data set \code{Xp}.}
}
\value{
A \code{list} with the elements
\item{statistic}{Test statistic}
\item{p.value}{The \eqn{p}-value for the hypothesis test for the corresponding \code{alternative}}
\item{conf.int}{Confidence interval for the arc density at the given confidence level \code{conf.level} and
depends on the type of \code{alternative}.}
\item{estimate}{Estimate of the parameter, i.e., arc density}
\item{null.value}{Hypothesized value for the parameter, i.e., the null arc density, which is usually the
mean arc density under uniform distribution.}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{data.name}{Name of the data set}
}
\description{
An object of class \code{"htest"}.
This is an \code{"htest"} (i.e., hypothesis test) function which performs a hypothesis test of uniformity of 1D data
in one interval based on the normal approximation of the arc density of the PE-PCD with expansion parameter \eqn{r \ge 1}
and centrality parameter \eqn{c \in (0,1)}.

The function yields the test statistic, \eqn{p}-value for the
corresponding \code{alternative}, the confidence interval, estimate and null value for the parameter of interest
(which is the arc density), and method and name of the data set used.

The null hypothesis is that data is
uniform in a finite interval (i.e., arc density of PE-PCD equals to its expected value under uniform
distribution) and \code{alternative} could be two-sided, or left-sided (i.e., data is accumulated around the end
points) or right-sided (i.e., data is accumulated around the mid point or center \eqn{M_c}).

See also (\insertCite{ceyhan:metrika-2012,ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
\dontrun{
c<-.4
r<-2
a<-0; b<-10; int<-c(a,b)

n<-100  #try also n<-20, 1000
Xp<-runif(n,a,b)

TSArcDensPEint(Xp,int,r,c)
TSArcDensPEint(Xp,int,r,c,alt="g")
TSArcDensPEint(Xp,int,r,c,alt="l")
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{TSArcDensCSint}}
}
\author{
Elvan Ceyhan
}
