% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{group_test}
\alias{group_test}
\title{Performs multiple mean comparisons for a data.frame}
\usage{
group_test(
  df,
  group,
  metadata = NULL,
  method = "wilcox.test",
  threads = 1,
  p.adjust.method = "BH",
  verbose = TRUE
)
}
\arguments{
\item{df}{a data.frame}

\item{group}{The compare group (categories) in your data, one column name of metadata when metadata exist or a vector whose length equal to columns number of df.}

\item{metadata}{sample information dataframe contains group}

\item{method}{the type of test. Default is wilcox.test. Allowed values include:
\itemize{\item \code{\link[stats]{t.test}} (parametric) and \code{\link[stats]{wilcox.test}} (non-parametric). Perform comparison between two groups of samples. If the grouping variable contains more than two levels, then a pairwise comparison is performed.
\item \code{\link[stats]{anova}} (parametric) and \code{\link[stats]{kruskal.test}} (non-parametric). Perform one-way ANOVA test comparing multiple groups.}}

\item{threads}{default 1}

\item{p.adjust.method}{p.adjust.method, see \code{\link[stats]{p.adjust}}, default BH.}

\item{verbose}{logical}
}
\value{
data.frame
}
\description{
Performs multiple mean comparisons for a data.frame
}
\examples{
data(otutab)
group_test(otutab, metadata$Group, method = "kruskal.test")
group_test(otutab[, 1:12], metadata$Group[1:12], method = "wilcox.test")
}
