% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_prd.R
\name{filter_prd}
\alias{filter_prd}
\title{Filter dyad-year data to include just politically relevant dyads}
\usage{
filter_prd(data)
}
\arguments{
\item{data}{a dyad-year data frame (either "directed" or "non-directed")}
}
\value{
\code{filter_prd()} takes a dyad-year data frame, assuming it has columns for
major power status and contiguity type, calculates whether the dyad is "politically
relevant", and subsets the data frame to just those observations.
}
\description{
\code{filter_prd()} filters a dyad-year data frame to just those that
are "politically relevant." This is useful for discarding unnecessary (and unwanted)
observations that just consume space in memory.
}
\details{
"Political relevance" can be calculated a few ways. Right now, the function
considers only "direct" contiguity and Correlates of War major power status. You can employ
maximalist definitions of "direct contiguity" to focus on just the land-contiguous. This function
is inclusive of any type of contiguity relationship.

As of the slated release of version 0.5, \code{filter_prd()} is a shortcut for \code{add_contiguity()}
and/or \code{add_cow_majors()} if the function is executed in the absence of the data needed to create
politically relevant dyads. See the example below for what this means.
}
\examples{

\donttest{

# just call `library(tidyverse)` at the top of the your script
library(magrittr)

A <- cow_ddy \%>\% add_contiguity() \%>\% add_cow_majors() \%>\% filter_prd()

A

# you can also use it as a shortcut for the other functions required
# to calculate politically relevant dyads.
B <- cow_ddy \%>\% filter_prd()

B

identical(A,B)
}

}
\references{
Weede, Erich. 1976. "Overwhelming preponderance as a pacifying condition among
contiguous Asian dyads." \emph{Journal of Conflict Resolution} 20: 395-411.

Lemke, Douglas and William Reed. 2001. "The Relevance of Politically Relevant Dyads."
\emph{Journal of Conflict Resolution} 45(1): 126-144.
}
\author{
Steven V. Miller
}
