% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wallyPlot.R
\name{wallyPlot}
\alias{wallyPlot}
\title{Wally plots to assess calibration of a risk or survival prediction}
\usage{
wallyPlot(object, time, formula, data, cause = 1, q = 10, ylim,
  hanging = FALSE, seed = NULL, mar = c(4.1, 4.1, 2, 2), colbox = "red",
  type = "risk", pseudo = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{object}{Probabilistic survival predictions or probabilistic event risk predictions
evaluated at \code{time} for the subjects in \code{data}. Either
given in form of a numeric vector of probabilistic predictions or
as an object which in the survival setting has a
\code{predictSurvProb} method and in the competing risks setting
has a \code{predictEventProb} method.}

\item{time}{Time interest for evaluating calibration of the
predictions.}

\item{formula}{A survival or event history formula. The left hand
side is used to compute the expected event status. If
\code{formula} is \code{missing}, try to extract a formula from
the first element in object.}

\item{data}{A data frame in which to validate the prediction
models and to fit the censoring model. If \code{data} is missing,
try to extract a data set from the first element in object.}

\item{cause}{For competing risks settings the cause of interest.}

\item{q}{The number of quantiles. Defaults to 10.}

\item{ylim}{Limits of y-axis. If missing the function tries to
find appropriate limits based on the simulated and real data.}

\item{hanging}{If \code{TRUE}, hang bars corresponding to observed
frequencies at the value of the corresponding prediction.}

\item{seed}{A seed value to make results reproducible.}

\item{mar}{Plot margins passed to par.}

\item{colbox}{Color of the box which identifies the real data
calibration plot.}

\item{type}{For survival models only: show either "risk" or
"survival".}

\item{pseudo}{Logical. Determines the method for estimating expected event frequencies. See \code{calPlot}. Default is \code{FALSE}.}

\item{verbose}{If \code{TRUE} warn about missing formula and data.}

\item{...}{Further arguments passed to \code{calPlot}.}
}
\value{
List of simulated and real data.
}
\description{
Wally plots to assess calibration of a risk or survival prediction
}
\examples{

# Survival setting
library(prodlim)
library(survival)
set.seed(180)
d = SimSurv(180)
f = coxph(Surv(time,status)~X1+X2,data=d)
\dontrun{
wallyPlot(f,
          time=4,
          q=10,
          type="risk",
          data=d,
          formula=Surv(time,status)~1)
 wallyPlot(f,
          time=4,
          q=10,
          hanging=TRUE,
          type="survival",
          data=d,
          formula=Surv(time,status)~1)
}

# Competing risks setting
library(prodlim)
library(survival)
library(riskRegression)
set.seed(180)
d2 = SimCompRisk(180)
f2 = CSC(Hist(time,event)~X1+X2,data=d2)
\dontrun{
wallyPlot(f2,
          time=5,
          q=3,
          hanging=TRUE,
          data=d2,
          formula=Hist(time,event)~1)
          
}

}
\seealso{
calPlot
}
\author{
Paul F. Blanche <paul.blanche@univ-ubs.fr> and Thomas A. Gerds <tag@biostat.ku.dk>
}
