% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_norm.R
\name{est_norm}
\alias{est_norm}
\title{Estimate Normal Distribution Given Set of Quantile Values}
\usage{
est_norm(q, p, weights = rep(1, length(p)), ...)
}
\arguments{
\item{q}{quantile values.}

\item{p}{probabilities corresponding to the \code{q} quantiles.}

\item{weights}{relative weight of each quantile.  The higher the weight the
better the approximated distribution will be at fitting that quantile.}

\item{...}{passed to \code{\link[stats]{optim}}.}
}
\value{
a \code{pedbp_est_norm} object.  This is a list with elements:
\itemize{
  \item{par}{a named numeric vector with the mean and standard deviation for a Gaussian distribution}
  \item{qp}{a numeric matrix with two columns built from the input values of
  \code{q} and \code{p}}
  \item{weights}{the \code{weights} used}
  \item{call}{The call made}
  \item{optim}{result from calling \code{\link[stats]{optim}}}
}
}
\description{
With at least two quantile values find the mean and standard deviation of a
normal distribution to match up with empirical values provided.
}
\details{
For X ~ N(mu, sigma), Pr[X <= q] = p

Given the set of quantiles and probabilities, \code{est_norm} uses
\code{\link[stats]{optim}} to find the preferable mean and standard deviation
of a normal distribution to fit the provided quantiles.

Use the \code{weight} argument to emphasize which, if any, of the provided
quantiles needs to be approximated closer than others.  By default all the
quantiles are weighted equally.
}
\examples{

# Example 1
q <- c(-1.92, 0.1, 1.89) * 1.8 + 3.14
p <- c(0.025, 0.50, 0.975)

x <- est_norm(q, p)
str(x)
x

plot(x)

# Example 2 -- build with quantiles that are easy to see unlikely to be from
# a Normal distribuiton
q <- c(-1.92, 0.05, 0.1, 1.89) * 1.8 + 3.14
p <- c(0.025, 0.40, 0.50, 0.975)

# with equal weights
x <- est_norm(q, p)
x
plot(x)

# weight to ignore one of the middle value and make sure to hit the other
x <- est_norm(q, p, weights = c(1, 2, 0, 1))
x
plot(x)

# equal weight the middle, more than the tails
x <- est_norm(q, p, weights = c(1, 2, 2, 1))
x
plot(x)

}
