% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedigree.R
\name{getGenAncestors}
\alias{getGenAncestors}
\title{Counts number of generations of ancestors for one subject. Use recursion.}
\usage{
getGenAncestors(ped, id, ngen = NULL)
}
\arguments{
\item{ped}{data.frame with a pedigree and a column for the number of
generations of each subject.}

\item{id}{subject for which we want the number of generations.}

\item{ngen}{number of generation}
}
\value{
a data frame object with the pedigree and generation of
  ancestors for subject id.
}
\description{
Counts number of generations of ancestors for one subject. Use recursion.
}
\examples{
ped <- pedigree(sire = c(NA, NA, 1,  1, 4, 5),
                dam =  c(NA, NA, 2, NA, 3, 2),
                label = 1:6)
ped <- ped2DF(ped)
ped$id <- row.names(ped)
ped$generation <- NA
(tmp1 <- getGenAncestors(ped, id = 1))
(tmp2 <- getGenAncestors(ped, id = 4))
(tmp3 <- getGenAncestors(ped, id = 6))

# Test for correctness
stopifnot(tmp1$generation[1] == 0)
stopifnot(all(is.na(tmp1$generation[-1])))
stopifnot(all(tmp2$generation[c(1, 4)] == c(0, 1)))
stopifnot(all(is.na(tmp2$generation[-c(1, 4)])))
stopifnot(all(tmp3$generation == c(0, 0, 1, 1, 2, 3)))
}
