% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCor.R
\name{plotCor}
\alias{plotCor}
\title{Correlation plot}
\usage{
plotCor(r, r2, col, breaks, col.names, ...)
}
\arguments{
\item{r}{A square matrix with correlation values.}

\item{r2}{(optional) A second square matrix with correlation values.}

\item{col}{(optional) Color table to use for \code{image} -- see \code{\link[graphics:image]{graphics::image()}} for details. The
default is a colorblind-friendly palette created using the \strong{RColorBrewer} palette \code{"RdBu"}.}

\item{breaks}{(optional) Break points in sorted order to indicate the intervals for assigning the
colors. See \code{\link[fields:image.plot]{fields::image.plot()}} for more details.}

\item{col.names}{(optional) Character vector with short (up to 5 characters) column names.}

\item{...}{(optional) Additional parameters passed to plotting functions.}
}
\value{
A correlation plot.
}
\description{
Plotting correlation matrices.
}
\details{
A correlation plot in an alternative way of showing the strength of the empirical correlations
between variables. This is done by using a diverging color palette, where the darker the color,
the stronger the absolute correlation value.

\code{\link[=plotCor]{plotCor()}} can also be used to compare correlations between the same variables at
different points in time or space or for different observations. This is done by passing two
square correlation matrices using arguments \code{r} and \code{r2}. The lower triangle of the resulting
correlation plot will contain correlations from \code{r}, correlations from \code{r2} will be in the upper
triangle, and the diagonal will be empty.
}
\section{Dependencies}{

The \strong{fields} package, provider of tools for spatial data in R, is required for
\code{\link[=plotCor]{plotCor()}} to work. The development version of the \strong{fields} package is
available on \url{https://github.com/dnychka/fieldsRPackage} while its old versions are available on
the CRAN archive at \url{https://cran.r-project.org/src/contrib/Archive/fields/}.
}

\examples{
if (all(c(require(sp), require(fields)))) {
  data(meuse, package = "sp")
  cols <- c("cadmium", "copper", "lead", "zinc", "elev", "dist", "om")

  # A single correlation matrix
  r <- cor(meuse[1:20, cols], use = "complete")
  r <- round(r, 2)
  plotCor(r)

  # Two correlation matrices: r2 goes in the upper triangle
  r2 <- cor(meuse[21:40, cols], use = "complete")
  r2 <- round(r2, 2)
  plotCor(r, r2)
}
}
\references{
Neuwirth E (2022). \emph{RColorBrewer: ColorBrewer Palettes}. R package version 1.1-3,
\url{https://CRAN.R-project.org/package=RColorBrewer}.
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
