% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cont2cat.R
\name{cont2cat}
\alias{breakPoints}
\alias{cont2cat}
\alias{stratify}
\title{Stratification and categorization of continuous data}
\usage{
cont2cat(x, breaks, integer = FALSE)

breakPoints(x, n, type = "area", prop = FALSE)

stratify(x, n, type = "area", integer = FALSE)
}
\arguments{
\item{x}{Vector, data frame or matrix; the continuous data to be processed.}

\item{breaks}{Vector or list; the lower and upper limits that should be used
to break the continuous data into categories. See \sQuote{Details} for more
information.}

\item{integer}{Logical value; should the categorical data be returned as
integers? Defaults to \code{integer = FALSE}.}

\item{n}{Integer value; the number of strata that should be created.}

\item{type}{Character value; the type of strata, with options \code{"area"},
for equal-area, and \code{"range"}, for equal-range strata. Defaults to
\code{type = "area"}.}

\item{prop}{Logical value; should the marginal strata proportions be
returned? Defaults to \code{prop = FALSE}.}
}
\value{
A vector, data frame, or matrix, depending on the class of \code{x}.
}
\description{
Compute break points and marginal strata proportions, stratify and convert
continuous data (numeric) into categorical data (factor or integer).
}
\details{
Breaks must be a vector if \code{x} is a vector, but a list if \code{x} is a
data frame or matrix. Using a list allows breaking the data into a different
number of classes.
}
\examples{
## Compute the break points of marginal strata
x <- data.frame(x = round(rnorm(10), 1), y = round(rlnorm(10), 1))
x <- breakPoints(x = x, n = 4, type = "area", prop = TRUE)
x

## Convert continuous data into categorical data
# Matrix
x <- y <- c(1:10)
x <- cbind(x, y)
breaks <- list(c(1, 2, 4, 8, 10), c(1, 5, 10))
y <- cont2cat(x, breaks)
y
# Data frame
x <- y <- c(1:10)
x <- data.frame(x, y)
breaks <- list(c(1, 2, 4, 8, 10), c(1, 5, 10))
y <- cont2cat(x, breaks, integer = TRUE)
y
# Vector
x <- c(1:10)
breaks <- c(1, 2, 4, 8, 10)
y <- cont2cat(x, breaks, integer = TRUE)
y

## Stratification
x <- data.frame(x = round(rlnorm(10), 1), y = round(rnorm(10), 1))
x <- stratify(x = x, n = 4, type = "area", integer = TRUE)
x
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
\seealso{
\code{\link[Hmisc]{cut2}}
}

