% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/vgmLags.R
\name{vgmLags}
\alias{vgmLags}
\title{Lag-distance classes for variogram estimation}
\usage{
vgmLags(obj, n = 7, type = "exp", cutoff = 0.5, base = 2,
  zero = 0.001)
}
\arguments{
\item{obj}{Data frame or matrix; the x and y coordinates (the coordinates
must be projected).}

\item{n}{Integer value; the number of lag-distace classes. Defaults to
\code{n = 7}.}

\item{type}{Caracter value; the type of lag-distance classes, with options
\code{equi} (equidistant) and \code{exp} (exponential). Defaults to
\code{type = "exp"}.}

\item{cutoff}{Numeric value; the fraction of the maximum pair-wise sepation
distances that should be used to compute the lag-distance classes.
Defaults to \code{cutoff = 0.5}.}

\item{base}{Numeric value; the base of the exponential expression used to
create exponentially spaced lag-distance classes. Used only when
\code{type = "exp"}. Defaults to \code{base = 2}.}

\item{zero}{Numeric value; the minimum pair-wise separation distance that
should be used to compute the lag-distance classes. Defaults to
\code{zero = 0.0001}.}
}
\value{
Vector of numeric values with the breaks of the lag-distance classes.
}
\description{
Computation of lag-distance classes for varioram estimation.
}
\examples{
require(sp)
data(meuse.grid)
id <- sample(nrow(meuse.grid), 100)
obj <- meuse.grid[id, 1:2]
vgmLags(obj)
}
\author{
Alessandro Samuel-Rosa <\email{alessandrosamuelrosa@gmail.com}>
}
\references{
Truong, P. N.; Heuvelink, G. B. M.; Gosling, J. P. Web-based tool for expert
elicitation of the variogram. \emph{Computers and Geosciences}. v. 51, p.
390-399, 2013.
}
\seealso{
\code{\link[spsann]{optimPPL}}
}
\concept{
variogram
}

