% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pq_perf.R
\name{pq_perf}
\alias{pq_perf}
\title{creating performance trends}
\usage{
pq_perf(dt, date_range = "max", from = NULL, to = Sys.Date(),
  x = "close|value", base_value = 1)
}
\arguments{
\item{dt}{a list/dataframe of time series dataset}

\item{date_range}{date range. Available value includes '1m'-'11m', 'ytd', 'max' and '1y'-'ny'. Default is max.}

\item{from}{the start date. Default is NULL. If it is NULL, then calculate using date_range and end date.}

\item{to}{the end date. Default is the current date.}

\item{x}{the name of column to calculate. Default is 'close|value'.}

\item{base_value}{the base value of performance index. Default is 0.}
}
\description{
\code{pq_perf} provides an easy way to create the performance trends for a set of time series data.
}
\examples{
 
\donttest{
# load data
dat = md_stock(c('000001', '^000001'), date_range = 'max', source = '163')

# create performance trends
perf = pq_perf(dat)
# pq_plot(perf)

}

}
