
#' @import data.table 
#' @importFrom jsonlite fromJSON
#' @importFrom stringi stri_unescape_unicode
md_stock_spotall_163 = function(symbol = c('a','index'), only_symbol = FALSE, show_tags = FALSE, to_sysdata=FALSE, ...) {
  prov = tags = market = exchange = time = . = submarket = region = board = name = mkt = indu = sec = NULL
    
  fun_stock_163 = function(urli, mkt) {
    code = symbol = exchange = . = name = high = low = price = yestclose = updown = percent = hs = volume = turnover = mcap = tcap = pe = mfsum = net_income = revenue = plate_ids = time = NULL
    # stock
    # c('code', 'five_minute' 'high', 'hs', 'lb', 'low', 'mcap', 'mfratio', 'mfsum', 'name', 'open', 'pe', 'percent', 'plate_ids', 'price', 'sname', 'symbol', 'tcap', 'turnover', 'updown', 'volume', 'wb', 'yestclose', 'zf', 'no', 'announmt', 'uvsnews')
    # index
    # c('code', 'high', 'low', 'name', 'open' 'percent', 'price', 'symbol', 'time', 'turnover' 'updown', 'volume', 'yestclose', 'no', 'zhenfu') 
    data_date = md_stock_spot_tx('^000001')$date
    jsonDat = fromJSON(urli)
    
    jsonDF = jsonDat$list
    if (mkt == 'stock') {
      jsonDF$net_income = jsonDF$MFRATIO$MFRATIO2
      jsonDF$revenue = jsonDF$MFRATIO$MFRATIO10
      jsonDF[,c('MFRATIO', 'UVSNEWS','ANNOUNMT','NO')] = NULL 
      names(jsonDF) = tolower(names(jsonDF))
      
      jsonDF = setDT(jsonDF)[,`:=`(
        date = data_date, #as.Date(substr(jsonDat$time,1,10)), 
        time = jsonDat$time#,
        #strptime(jsonDat$time, '%Y-%m-%d %H:%M:%S', tz = 'Asia/Shanghai')
      )][, .(symbol, name, date, open, high, low, close=price, close_prev=yestclose, change=updown, change_pct=percent*100, volume, amount=turnover, turnover=hs*100, cap_market=mcap, cap_total=tcap, pe_last=pe, eps=mfsum, net_income, revenue, plate_ids, time=as.POSIXct(time))
      ][,`:=`(
        province = sub('.*(dy\\d+).*', '\\1', plate_ids),
        plate_ids = sub('dy\\d+','',plate_ids)
      )][,`:=`(
        sector = sub('.*((hy\\d{3}0{3})|hy012001).*', '\\1', plate_ids),
        industry = sub('.*(hy\\d+).*', '\\1', sub('hy\\d{3}0{3}','',plate_ids))
      )]
      
    } else if (mkt == 'index') {
      names(jsonDF) = tolower(names(jsonDF))
      
      jsonDF = setDT(jsonDF)[,`:=`(
        date = data_date#as.Date(substr(jsonDat$time,1,10))
      )][, .(symbol, name, date, open, high, low, close=price, close_prev=yestclose, change=updown, change_pct=percent*100, volume=volume/100, amount=turnover, time=as.POSIXct(time))]
    }
    
    return(jsonDF[, `:=`(market = mkt, region = 'cn')])
  }
  
  urls_163 = list(
    a = 'http://quotes.money.163.com/hs/service/diyrank.php?host=http%3A%2F%2Fquotes.money.163.com%2Fhs%2Fservice%2Fdiyrank.php&page=0&query=STYPE%3AEQA&fields=NO%2CSYMBOL%2CNAME%2CPLATE_IDS%2CPRICE%2CPERCENT%2CUPDOWN%2CFIVE_MINUTE%2COPEN%2CYESTCLOSE%2CHIGH%2CLOW%2CVOLUME%2CTURNOVER%2CHS%2CLB%2CWB%2CZF%2CPE%2CMCAP%2CTCAP%2CMFSUM%2CMFRATIO.MFRATIO2%2CMFRATIO.MFRATIO10%2CSNAME%2CCODE%2CANNOUNMT%2CUVSNEWS&sort=CODE&order=desc&count=100000&type=query', 
    b = 'http://quotes.money.163.com/hs/service/diyrank.php?host=http%3A%2F%2Fquotes.money.163.com%2Fhs%2Fservice%2Fdiyrank.php&page=0&query=STYPE%3AEQB&fields=NO%2CSYMBOL%2CNAME%2CPLATE_IDS%2CPRICE%2CPERCENT%2CUPDOWN%2CFIVE_MINUTE%2COPEN%2CYESTCLOSE%2CHIGH%2CLOW%2CVOLUME%2CTURNOVER%2CHS%2CLB%2CWB%2CZF%2CPE%2CMCAP%2CTCAP%2CMFSUM%2CMFRATIO.MFRATIO2%2CMFRATIO.MFRATIO10%2CSNAME%2CCODE%2CANNOUNMT%2CUVSNEWS&sort=PERCENT&order=desc&count=100000&type=query',
    index = 'http://quotes.money.163.com/hs/service/hsindexrank.php?host=/hs/service/hsindexrank.php&page=0&query=IS_INDEX:true;EXCHANGE:CNSESH&fields=no,TIME,SYMBOL,NAME,PRICE,UPDOWN,PERCENT,zhenfu,VOLUME,TURNOVER,YESTCLOSE,OPEN,HIGH,LOW&sort=SYMBOL&order=asc&count=10000&type=query',
    index = 'http://quotes.money.163.com/hs/service/hsindexrank.php?host=/hs/service/hsindexrank.php&page=0&query=IS_INDEX:true;EXCHANGE:CNSESZ&fields=no,TIME,SYMBOL,NAME,PRICE,UPDOWN,PERCENT,zhenfu,VOLUME,TURNOVER,YESTCLOSE,OPEN,HIGH,LOW&sort=SYMBOL&order=asc&count=10000&type=query'
  )
  idx = which(names(urls_163) %in% symbol) #unlist(strsplit(symbol,','))
  
  df_stock_cn = try(
    rbindlist(
      mapply(fun_stock_163, urls_163[idx], c('stock','stock','index','index')[idx], SIMPLIFY = FALSE), 
      fill = TRUE
    ), 
    silent = TRUE
  )#, idcol = 'mkt')#[mkt %in% c('a','b'), mkt := 'stock']
  if (!inherits(df_stock_cn, 'try-error') & 'fund' %in% symbol) df_stock_cn = rbind(df_stock_cn, md_fund_spotall_163(), fill=TRUE)
  
  # date time of download
  datetime = gsub('[^(0-9)]','',df_stock_cn[1,time])
  # if (df_stock_cn[1,time] < as.POSIXct(paste(df_stock_cn[1,date], '15:00:00'))) 
  #   cat('The close price is spot price at', as.character(datetime), '\n')

  # create/export sysdata.rda 
  if (to_sysdata) return(df_stock_cn)
  # create/export symbol only or tags
  if (only_symbol || show_tags) {
    if (inherits(df_stock_cn, 'try-error')) df_stock_cn = setDT(copy(symbol_stock_163))
    
    df_stock_cn = symbol_163_format(df_stock_cn)
    if ('prov' %in% names(df_stock_cn)) df_stock_cn = df_stock_cn[is.na(prov), prov := stri_unescape_unicode('\\u91cd\\u5e86')]
    
    if (only_symbol & show_tags) {
      df_stock_cn = df_stock_cn[
        , .(market, submarket, region, exchange, board, symbol, name, prov, sec, indu)
        ][order(-market, exchange, symbol)]
    } else if (only_symbol) {
      df_stock_cn = df_stock_cn[
        , .(market, submarket, region, exchange, board, symbol, name)
        ][order(-market, exchange, symbol)]
    }
  } else {
    if (!identical(symbol, 'index')) {
      cols_rm = intersect(names(df_stock_cn), c('eps', 'net_income', 'revenue'))
      if (length(cols_rm)>0) df_stock_cn = df_stock_cn[, (cols_rm) := NULL]
    }
  }
  
  df = df_stock_cn[,unit := 'CNY'][, symbol := check_symbol_for_yahoo(symbol, market)]#[, mkt := NULL][]
  
  cols_rm = intersect(names(df), c('sector', 'industry', 'province', 'plate_ids', 'region')) # , 'close_prev', 
  if (length(cols_rm)>0) df = df[, (cols_rm) := NULL]
  return(df)
}


# query spot data from tx
# http://api.money.126.net/data/feed/1000001,money.api
# hq.sinajs.cn/list=sz150206
# http://qt.gtimg.cn/q=sz000001
md_stock_spot_tx = function(symbol1, only_syb_nam = FALSE, ...) {
  V1=V2=doc=.=symbol=name=high=low=close_prev=change=change_pct=volume=amount=turnover=cap_market=cap_total=pb=pe_last=pe_trailing=pe_forward=NULL
  
  syb = paste0(check_symbol_for_tx(symbol1), collapse=',')
  dt = try(readLines(sprintf('http://qt.gtimg.cn/q=%s', syb)), silent = TRUE)
  if (inherits(dt, 'try-error')) readLines(sprintf('http://web.sqt.gtimg.cn/q=%s', syb))
  
  dt = data.table(
    doc = dt
  )[, doc := iconv(doc, 'GB18030', 'UTF-8')
  ][, doc := sub('.+=\"\\d+~(.+)\".+', '\\1', doc)
  ][, tstrsplit(doc, '~')
  ][, V1 := gsub('\\s', '', V1)]
  
  if (only_syb_nam) {
    return(dt[,.(symbol = check_symbol_for_yahoo(symbol1), name = V1)])
  }
  
  colnames_en = c('name', 'symbol', 'close', 'close_prev', 'open',
                  'volume', 'buy', 'sell', 
                  'bid1', 'bid1_volume', 'bid2', 'bid2_volume', 'bid3', 'bid3_volume', 'bid4', 'bid4_volume', 'bid5', 'bid5_volume',
                  'ask1', 'ask1_volume', 'ask2', 'ask2_volume', 'ask3', 'ask3_volume', 'ask4', 'ask4_volume', 'ask5', 'ask5_volume',
                  'last_trade', 'date', 'change', 'change_pct', 'high', 'low', 
                  '', 'volume', 'amount', 'turnover', 
                  'pe_trailing', '', 'high', 'low', '', 'cap_market', 'cap_total', 'pb', '', '', '', '', 'average', 'pe_forward', 'pe_last' )
  if (ncol(dt) <= 53) {
    colnames_en = colnames_en[seq_len(ncol(dt))]
  } else {
    colnames_en = c(colnames_en, rep('', ncol(dt)-53))
  }
  setnames(dt, colnames_en)
  
  num_cols = c(
    'open', 'high', 'low', 'close', 'close_prev', 'change', 'change_pct', 'volume', 'amount', 'turnover', 'cap_market', 'cap_total', 'pb', 'pe_last', 'pe_trailing', 'pe_forward'
  )
  dt = dt[,.(
    symbol, name, date, open, high, low, close, close_prev, change, change_pct, volume, amount, turnover, cap_market, cap_total, pb, pe_last, pe_trailing, pe_forward#, 
    #buy, sell, 
    #bid1, bid1_volume, bid2, bid2_volume, bid3, bid3_volume, bid4, bid4_volume, bid5, bid5_volume, 
    #ask1, ask1_volume, ask2, ask2_volume, ask3, ask3_volume, ask4, ask4_volume, ask5, ask5_volume
    )][, (num_cols) := lapply(.SD, as.numeric), .SDcols= num_cols
     ][, `:=`(
       symbol = check_symbol_for_yahoo(symbol1),
       volume = volume,
       amount = amount*10000,
       cap_market = cap_market*10^8, 
       cap_total = cap_total*10^8,
       time = as.POSIXct(date, format='%Y%m%d%H%M%S', tz='Asia/Shanghai'),
       date = as.Date(date, format='%Y%m%d%H%M%S')
     )]
  
  # if (dt[1,time] < as.POSIXct(paste(dt[1,date], '15:00:00')))
  #   cat('The close is the spot price at', dt[1, as.character(time)], '\n')
  
  return(dt[, `:=`(unit = 'CNY')])
}



md_stock_info1_163 = function(symbol1, str_income_hist = FALSE, ...) {
  . = N = V1 = X1 = X2 = X3 = X4 = income_by = mkt = rd = rid = NULL
  
  # symbol1 = '600036'
  # http://quotes.money.163.com/f10/gszl_600036.html#01f01
  # http://quotes.money.163.com/service/gszl_600036.html?type=cp
  # http://quotes.money.163.com/service/gszl_600036.html?type=hy
  # http://quotes.money.163.com/service/gszl_600036.html?type=dy
  
  # skip index
  if (check_symbol_cn(symbol1)[, mkt == 'index' || is.na(mkt)]) return(NULL)
  # symbol1 = '000001'
  stk_price = md_stock_spot_tx(symbol1, only_syb_nam=TRUE)
  # columns
  income_strcols = c('income', 'cost', 'profit', 'gross_margin', 'profit_proportion')
  employee_strcols = c('number', 'proportion')
  
  if (str_income_hist) {
    income_hist_preprocess = function(dat, type) {
      income_strcols = c('income', 'cost', 'profit', 'gross_margin', 'profit_proportion')
      
      rbindlist(lapply(
        split(income_product[
          , rid := 0
        ][V1 == income_product[1,1], rid := 1
        ][, rid := cumsum(rid)][], by = 'rid'), 
        function(x) {
          setnames(
            x[-c(1:2),
            ][, report_date := x[1,5]
            ][, income_by := type
            ][, c(8,9,1:6)], 
            c('report_date', 'income_by', 'variable', income_strcols)
          )
        }
      ))[, (income_strcols) := lapply(.SD, function(x) {
        as.numeric(gsub(',|\\s|-|%', '', x))
      }), .SDcols = income_strcols][]
    }
    
    income_product = load_read_csv(
      sprintf('http://quotes.money.163.com/service/gszl_%s.html?type=cp', symbol1), 
      encode = 'GBK', csv_header = FALSE
    )
    income_product2 = income_hist_preprocess(income_product, type = 'product')
    
    
    income_industry = load_read_csv(
      sprintf('http://quotes.money.163.com/service/gszl_%s.html?type=hy', symbol1), 
      encode = 'GBK', csv_header = FALSE
    )
    income_industry2 = income_hist_preprocess(income_industry, type = 'industry')
    
    
    income_location = load_read_csv(
      sprintf('http://quotes.money.163.com/service/gszl_%s.html?type=dy', symbol1), 
      encode = 'GBK', csv_header = FALSE
    )
    income_location2 = income_hist_preprocess(income_location, type = 'location')
    
    
    retdat = list(str_income = cbind(
      stk_price,
      rbind(income_product2, income_industry2, income_location2)
    ))
  } else {
    # load all tables
    datweb = read_html(sprintf(
      'http://quotes.money.163.com/f10/gszl_%s.html#01f01', 
      sub("^.*?([0-9]+).*$",'\\1', symbol1)
    ))
    report_date = 
      data.table(
        rd = html_text(html_nodes(datweb, 'div.report_date span'))
      )[, report_date := sub('.*([0-9]{4}-[0-9]{2}-[0-9]{2}).*', '\\1', rd) 
      ][,.N, by = report_date][order(-N)][1, .(report_date)] 
    
    tbls = rvest::html_table(datweb, fill = TRUE, header = FALSE)
    
    profile = 
      rbind(
        setDT(tbls[[4]])[1:9,   .(variable = X1, value = X2)], 
        setDT(tbls[[4]])[1:9,   .(variable = X3, value = X4)], 
        setDT(tbls[[4]])[10:12, .(variable = X1, value = X2)]
      )
    
    ipo = setDT(tbls[[5]])[, .(variable = X1, value = X2)][]
    info = cbind(stk_price, rbindlist(list(profile=profile, ipo=ipo), idcol = 'info_type'))
    
    
    str_income = tbls[7:9]
    names(str_income) = c('prodcut', 'industry', 'location')
    str_income = rbindlist(
      lapply( str_income, function(x) setnames(x[-1,], c('variable', income_strcols)) ), 
      idcol = 'income_by'
    )[, (income_strcols) := lapply(.SD, function(x) {
      as.numeric(gsub(',|\\s|-|%', '', x))
    }), .SDcols = income_strcols][]
    str_income = cbind(stk_price, report_date, str_income)
    
    str_employee = tbls[10:11]
    names(str_employee) = c('education', 'work_type')
    str_employee = rbindlist(
      lapply(str_employee, function(x) setnames(x[-1,], c('variable', employee_strcols))), 
      idcol = 'employee_by'
    )[, (employee_strcols) := lapply(.SD, function(x) {
      as.numeric(gsub('\\s|%', '', x))
    }), .SDcols = employee_strcols]
    str_employee = cbind(stk_price, report_date, str_employee)
    
    retdat = list(
      info = info, 
      str_income = str_income, 
      str_employee = str_employee
    )
  }
  
  return(retdat)
}

#' @import data.table
#' @importFrom readr read_csv locale col_date col_character col_double col_integer
md_stock_hist1_163 = function(symbol1, from='1900-01-01', to=Sys.Date(), zero_rm=TRUE, ...) {
  V1 = name = change_pct = symbol = NULL
  # http://quotes.money.163.com/service/chddata.html?code=0000001&start=19901219&end=20180615&fields=TCLOSE;HIGH;LOW;TOPEN;LCLOSE;CHG;PCHG;VOTURNOVER;VATURNOVER
  # http://quotes.money.163.com/service/chddata.html?code=1399001&start=19910403&end=20180615&fields=TCLOSE;HIGH;LOW;TOPEN;LCLOSE;CHG;PCHG;VOTURNOVER;VATURNOVER
  # https://query1.finance.yahoo.com/v7/finance/download/^SSEC?period1=1526631424&period2=1529309824&interval=1d&events=history&crumb=mO08ZCtWRMI
  
  # 'http://api.finance.ifeng.com/akmonthly/?code=sh600000&type=last'
  # {'D': 'akdaily', 'W': 'akweekly', 'M': 'akmonthly'}
  
  if (check_symbol_cn(symbol1)$mkt == 'fund') return(md_fund_hist1_163(symbol1, from, to))
  
  # symbol
  syb = check_symbol_for_163(symbol1) 

  # date range
  fromto = lapply(list(from=from,to=to), function(x) format(check_fromto(x), '%Y%m%d'))
  
  # create link
  fields = c('TOPEN','HIGH','LOW','TCLOSE','LCLOSE','CHG','PCHG','VOTURNOVER','VATURNOVER','TURNOVER','MCAP','TCAP')
  link = sprintf('http://quotes.money.163.com/service/chddata.html?code=%s&start=%s&end=%s&fields=%s', syb, fromto$from, fromto$to, paste0(fields, collapse = ';'))
    # paste0('http://quotes.money.163.com/service/chddata.html?code=',syb,'&start=',fromto$from,'&end=',fromto$to,'&fields=TOPEN;HIGH;LOW;TCLOSE;LCLOSE;CHG;PCHG;VOTURNOVER;VATURNOVER;TURNOVER;MCAP;TCAP')
             
   
  
  # download data from 163
  dt <- read_csv(
    file=link, locale = locale(encoding = 'GBK'), na=c('', 'NA', 'None'),
    col_types=list(col_date(format = ''), col_character(), col_character(), col_double(), col_double(), col_double(), col_double(), col_double(), col_double(), col_double(), col_double(), col_double(), col_double(), col_double(), col_double()))
  attr(dt, 'spec') <- NULL
  setDT(dt)
  # dt <- load_read_csv(link, 'GBK')
  
  # set names of datatable
  cols_name = c('date', 'symbol', 'name', 'open', 'high', 'low', 'close', 'close_prev', 'change', 'change_pct', 'volume', 'amount', 'turnover', 'cap_market', 'cap_total')
  setnames(dt, cols_name)
  setkeyv(dt, 'date')
  
  # if (max(dt[['date']]) < lwd()) dt = rbindlist(list(dt, md_stock_spot1_tx(symbol1)[,names(dt), with=FALSE]), fill = FALSE)
  dt = dt[, symbol := check_symbol_for_yahoo(symbol1)][, (cols_name[c(2,3,1,4:15)]), with=FALSE]
  # if (max(dt[['date']]) < lwd()) dt = unique(dt, by='date')
  
  # fill zeros in dt
  if (zero_rm) {
    dt = dt[close != 0]
  } else {
    cols_name = c('open', 'high', 'low', 'close')
    dt = dt[, (cols_name) := lapply(.SD, fill0), .SDcols = cols_name]
  }
  
  
  # adding valuation ratios and adjust for dividend
  chk_syb = try(check_symbol_for_yahoo(dt[1, tstrsplit(symbol, '\\.')][,V1]), silent = TRUE)
  if (chk_syb == dt[1,symbol] && nrow(dt)>0) {
    valuation = list(...)[['valuation']]
    if (is.null(valuation)) valuation = FALSE
    if (valuation) dt = md_stock_pe1_163(dt)
    
    # adjust = list(...)[['adjust']]
    # if (is.null(adjust)) adjust = 'split'
    # adjust = ifelse(adjust, 'dividend', 'split') 
    dt = md_stock_adjust1(dt, source = '163', adjust = list(...)[['adjust']])
  }
  
  # create unit/name columns
  dt = dt[, unit := 'CNY']#[, name := name[.N]]
  setkeyv(dt, 'date')
  return(dt)
}

# valuation ratios pe, pb, ps, pcf
md_stock_pe1_163 = function(dat) {
  symbol=V1=var_id=value=fs_month_diff=REV_Q=REV=REV_Y=NP_Q=NP=NP_Y=fs_month=NP_Dec=NP_LY=date2=cap_total=BV=NIDCash=NULL
  
  
  # symbol1 = '000001'
  symbol1 = dat[1, tstrsplit(symbol, '\\.')][,V1]
  # main financial indicators
  mainfi = try(fs_type1_cn('fi0_main', symbol1), silent = TRUE)
  if (inherits(mainfi, 'try-error')) return(dat)
  
  # main financial indicators
  # book value per share
  # Revenue from 
  # Net profit
  # Net Increase (Decrease) in Cash and Cash Equivalents
  mfi = dcast(
    merge(
      mainfi[
        var_id %in% c(18,4,10,13)
        ][, value := ifelse(value==0, NA, value)], 
      data.table(var_id = c(18,4,10,13),
                 var = c('BV', 'REV', 'NP', 'NIDCash')),
      by = 'var_id', all.x = TRUE
    ), 
    date ~ var
  )[, `:=`(fs_month = month(date), fs_month_diff = mean(month(date) - shift(month(date), type='lag', fill = 0))), by = year(date)
  # trailing REV/Income from main operation  
  ][fs_month_diff == 3,                  REV_Q   := REV-shift(REV, type='lag'), by = year(date)
  ][fs_month_diff == 3 & is.na(REV_Q),   REV_Q   := REV
  ][fs_month_diff == 3,                  REV_Y := runSum(REV_Q, 4)
  # trailing NP/Net Income
  ][fs_month_diff == 3,                  NP_Q := NP-shift(NP, type='lag'), by = year(date)
  ][fs_month_diff == 3 & is.na(NP_Q),    NP_Q := NP
  ][fs_month_diff == 3,                  NP_Y := runSum(NP_Q, 4)
  # last year NP/Net Income              
  ][fs_month==12, NP_Dec := NP
  ][, NP_LY := shift(NP_Dec, type='lag')
  ][, NP_LY := fillna(NP_LY)
  ][fs_month_diff ==  3, date2 := as.Date(paste(year(date), month(date)- 2, 1, sep='-'))
  ][fs_month_diff ==  6, date2 := as.Date(paste(year(date), month(date)- 5, 1, sep='-'))
  ][fs_month_diff == 12, date2 := as.Date(paste(year(date), month(date)-11, 1, sep='-'))
  ][, date := date2]
  
  # merge mfi with dat
  cols_fillna = c('fs_month','BV','NIDCash', 'REV_Y', 'NP', 'NP_Y', 'NP_LY')
  dat_pbpe = merge(
    dat, 
    mfi[, c('date', cols_fillna), with=FALSE], all = TRUE, by = 'date'
  )[, (cols_fillna) := lapply(.SD, fillna), .SDcols = cols_fillna
  ][!is.na(symbol)
  ][,`:=`(
    pb = cap_total/BV/10000,
    pe_last = cap_total/NP_LY/10000, # last year ratio
    pe_trailing = cap_total/NP_Y/10000, # trailing twelve month
    pe_forward = cap_total/(NP/(fs_month/12))/10000, # forward
    ps = cap_total/REV_Y/10000,
    pcf = cap_total/NIDCash/10000
  )][, (cols_fillna) := NULL]
  
  return(dat_pbpe)
}

# dividends
#' @importFrom stringi stri_isempty
md_stock_divsplit1_163 = function(symbol1, from=NULL, to=NULL, ret = c('div', 'spl', 'rig')) {
  name = symbol = date2 = date1 = date0 = fenhong = . = songgu = spl = zhuanzeng = new_issues = old_issues = issue_price = issue_rate = splits = dividends = mkt = NULL
  
  # skip index
  if (check_symbol_cn(symbol1)[, mkt == 'index' || is.na(mkt)]) return(NULL)
  # symbol1 = '000001'
  stk_price = md_stock_spot_tx(symbol1, only_syb_nam=TRUE)
  # return dts
  div_spl = list()
  
  # get dividends
  tbls = sprintf('http://quotes.money.163.com/f10/fhpg_%s.html#01d05', sub("^.*?([0-9]+).*$",'\\1', symbol1)) %>%
    read_html(.) %>% 
    rvest::html_table(., fill = TRUE, header = TRUE)
  
  
  tbl_divspl = setDT(tbls[[4]])[-1][, lapply(.SD, function(x) replace(x, x=='--', NA))][,c(3:8)]
  setnames(tbl_divspl, c('songgu', 'zhuanzeng', 'fenhong', 'date0', 'date1', 'date2'))
  if (length(unique(unlist(tbl_divspl))) == 1 & nrow(tbl_divspl) == 1) {
    tbl_divspl = tbl_divspl[.0]
  } 
  tbl_divspl = tbl_divspl[
    , (c('songgu', 'zhuanzeng', 'fenhong')) := lapply(.SD, as.numeric), .SDcols = c('songgu', 'zhuanzeng', 'fenhong')
    ][, (c('date0', 'date1', 'date2')) := lapply(.SD, as.Date), .SDcols = c('date0', 'date1', 'date2')
      ][is.na(date2), date2 := date1
        ][order(date1)]
  
  if ('div' %in% ret) { # dividend
    tbl_divident = tbl_divspl[fenhong > 0]
    if (nrow(tbl_divident) == 0) {
      div_spl[['div']] = data.table(
          date      = Sys.Date(),
          dividends = 1
        )[.0]
    } else {
      div_spl[['div']] = tbl_divident[,.(
          date      = date1,
          dividends = fenhong/10
        )]
    }
  }
  
  if ('spl' %in% ret) { # split
    tbl_split = rbind(
      tbl_divspl[, .(spl = songgu, date = date1)][spl > 0],
      tbl_divspl[, .(spl = zhuanzeng, date = date1)][spl > 0]
    )[, lapply(.SD, sum), keyby = date]
    
    if (nrow(tbl_split) == 0) {
      div_spl[['spl']] = data.table(
          date   = Sys.Date(),
          splits = 1
        )[.0]
    } else {
      div_spl[['spl']] = tbl_split[,.(
          date   = as.Date(date),
          splits = spl/10
        )]
    }
  }
  
  if ('rig' %in% ret) { # rights issue/offering
    rig = setDT(tbls[[5]])[,c(8,5,6,3)]
    setnames(rig, c('date', 'new_issues', 'old_issues', 'issue_price'))
    if (length(unique(unlist(rig))) == 1 & nrow(rig) == 1) {
      div_spl[['rig']] = data.table(
        date = Sys.Date(), 
        issue_rate = 1, 
        issue_price = 1
      )[.0]
    } else {
      div_spl[['rig']] = rig[
        , (c('new_issues', 'old_issues')) := lapply(.SD, function(x) as.numeric(gsub('[^0-9\\.]', '', x))), .SDcols = c('new_issues', 'old_issues')
        ][new_issues > 0 & !stri_isempty(date)
          ][, .(
            date   = as.Date(date), 
            issue_rate = new_issues/old_issues, 
            issue_price
          )]
    }
  }
  
  div_spl = Reduce(
    function(x,y) merge(x,y,all=TRUE,by='date'), div_spl
  )[,.(date, splits, dividends, issue_rate, issue_price)][!is.na(date)]
  if (nrow(div_spl) == 0) stk_price = stk_price[.0]
  div_spl = cbind(stk_price, div_spl)
  setkeyv(div_spl, 'date')
  return(div_spl)
}



#' @import data.table
md_stock_163 = function(symbol, from='1900-01-01', to=Sys.Date(), print_step=1L, freq = 'daily', zero_rm=TRUE, ...) {
  # arguments
  arg_lst = list(...)
  # frequency
  freq = check_arg(freq, c('daily'))
  # type 
  type = arg_lst[['type']]
  # return valuation ratios
  if (!('valuation' %in% names(arg_lst))) arg_lst[['valuation']] = FALSE
  # if (!('adjust' %in% names(arg_lst))) arg_lst[['adjust']] = 'split'
  
  # query data
  if (type == 'spot') {
    fuc = 'md_stock_spot_tx'
    if (length(intersect(symbol, c('a','b','index', 'fund'))) > 0) fuc = 'md_stock_spotall_163'
    dat_list <- try(do.call(fuc, args=list(symbol=symbol, ...)), silent = TRUE)
      
  }  else if (type == 'history') {
    dat_list = load_dat_loop(symbol, 'md_stock_hist1_163', args = c(list(from = from, to = to, zero_rm = zero_rm), arg_lst), print_step=print_step)
    
  } else if (type == 'adjfactor') (
    dat_list = load_dat_loop(symbol, 'md_stock_divsplit1_163', args = list(from = from, to = to), print_step=print_step)
    
  ) else if (type == 'info') {
    dat_list = load_dat_loop(symbol, 'md_stock_info1_163', args = list(...), print_step=print_step)
  }
  
  rmcols_func = function(x) {
    name = NULL
    
    cols_rm = intersect(names(x), c('change')) #,'close_prev', 'change_pct'
    if (length(cols_rm)>0) x = x[, (cols_rm) := NULL]
    if ('name' %in% names(x)) x = x[, name := gsub('\\s', '', name)]
    return(x)
  }
  if (type %in% c('history', 'spot')) {
    if (inherits(dat_list, 'list')) {
      dat_list = lapply(dat_list, rmcols_func)
    } else if (inherits(dat_list, 'data.frame')) {
      dat_list = rmcols_func(dat_list)
    }
  }
  
  return(dat_list)
}


# fund data from 163
md_fund_spotall_163 = function() {
  . = fund = high = low = name = price = symbol = time = turnover = volume = yestclose = NULL
  
  dat_lst = lapply(list(
    fund_close = 'http://quotes.money.163.com/fn/service/fundtrade.php?host=/fn/service/fundtrade.php&page=0&query=STYPE:FDC;UPDOWN:_exists_true&fields=no,SYMBOL,NAME,SNAME,PRICE,UPDOWN,PERCENT,VOLUME,TURNOVER,OPEN,HIGH,LOW,YESTCLOSE,CODE&sort=PERCENT&order=desc&count=%s&type=query&callback=callback_11861237&req=0%s',
    fund_etf = 'http://quotes.money.163.com/fn/service/fundtrade.php?host=/fn/service/fundtrade.php&page=0&query=find:/ETF/;UPDOWN:_exists_true&fields=no,SYMBOL,NAME,SNAME,PRICE,UPDOWN,PERCENT,VOLUME,TURNOVER,OPEN,HIGH,LOW,YESTCLOSE,CODE&sort=PERCENT&order=desc&count=%s&type=query&callback=callback_1696032826&req=0%s',
    fund_lof = 'http://quotes.money.163.com/fn/service/fundtrade.php?host=/fn/service/fundtrade.php&page=0&query=find:/LOF/;UPDOWN:_exists_true&fields=no,SYMBOL,NAME,SNAME,PRICE,UPDOWN,PERCENT,VOLUME,TURNOVER,OPEN,HIGH,LOW,YESTCLOSE,CODE&sort=PERCENT&order=desc&count=%s&type=query&callback=callback_814011473&req=0%s',
    fund_leveraged = 'http://quotes.money.163.com/fn/service/fundtrade.php?host=/fn/service/fundtrade.php&page=0&query=FUND_TYPE4:_int_190701;UPDOWN:_exists_true&fields=no,SYMBOL,NAME,SNAME,PRICE,UPDOWN,PERCENT,VOLUME,TURNOVER,OPEN,HIGH,LOW,YESTCLOSE,CODE&sort=PERCENT&order=desc&count=%s&type=query&callback=callback_2112195916&req=0%s'
  ), function(u) {
    # fromJSON(sub('.+\((\\1)\)', readline(u)))
    url = sprintf(
      u, 20000,
      paste0(hour(Sys.time()), minute(Sys.time()))
    )
    
    # print(url)
    dt = read_lines(url)
    dt = fromJSON(sub('.+?\\((.+)\\)', '\\1', dt))
    dat = setDT(dt$list)[, time := dt$time]
    return(dat)
  })

  dat_df = rbindlist(dat_lst, idcol = 'fund')
  setnames(dat_df, tolower(names(dat_df)))
  
  dat_df = dat_df[, .(symbol = check_symbol_for_yahoo(symbol), date = md_stock_spot_tx('^000001')$date, name, open, high, low, close = price, close_prev = yestclose, change_pct = percent*100, volume, amount = turnover, market = fund, unit = 'CNY')] # change=updown, sname, 
  
  return(dat_df)
}
md_fund_hist1_163 = function(symbol1, from='1900-01-01', to=Sys.Date()) {
  . = amount = change_pct = discount_pct = high = low = mkt = turnover = volume = NULL
  
  # url = sprintf('http://api.finance.ifeng.com/akdaily/?code=%s&type=last', syb1)
  # {'D': 'akdaily', 'W': 'akweekly', 'M': 'akmonthly'}
  
  # from tx ------
  syb1 = check_symbol_for_tx(symbol1)
  dat1 = 'init'
  i=1
  datlst = list()
  yrng = year(seq(as.Date(to), as.Date(from), by = '-1 years'))
  while (!inherits(dat1, 'try-error')) {
    # print(yr1)
    yr1 = yrng[i]
    url = sprintf('http://data.gtimg.cn/flashdata/hushen/daily/%s/%s.js?visitDstTime=1', substr(yr1,3,4), syb1)
    dat1 = try(suppressWarnings(fread(url, showProgress=F)), silent = T)
    
    if(!inherits(dat1, 'try-error')) {
      setnames(dat1, c('date', 'open', 'high', 'low', 'close', 'volume'))
      datlst[[as.character(yr1)]] <- dat1
      i = i+1
    }
  }
  
  dat_tx = rbindlist(
    datlst
  )[, volume := gsub('[^0-9.]', '', volume)
  ][, lapply(.SD, as.numeric)
  ][, date := as.Date(paste0(substr(yrng[i],1,2), date), format = '%Y%m%d')
  ][order(date)]
  
  # from 163 ------
  url0 = sprintf('http://quotes.money.163.com/fund/zyjl_%s_0.html?start=%s&end=%s', check_symbol_cn('512510.sh')$syb, from, to)
  pagnum = read_html(url0) %>% 
    html_nodes('div.mod_pages a') %>% 
    html_text() %>% .[-length(.)] %>% 
    as.integer() %>% max(., na.rm = T)
  
  dat_lst2 = lapply(
    sprintf('http://quotes.money.163.com/fund/zyjl_%s_%s.html?start=%s&end=%s', check_symbol_cn('512510.sh')$syb, seq(0,pagnum-1), from, to), 
    function(u) {
      read_html(u) %>% html_table(fill = TRUE) %>% .[[1]]
    }
  )
  dat_163 = rbindlist(dat_lst2)
  setnames(dat_163, c('date', 'close', 'change_pct', 'volume', 'amount', 'turnover', 'discount_pct'))
  dat_1632 = copy(dat_163)[, `:=`(
    date = as.Date(date), 
    change_pct = as.numeric(sub('%', '', change_pct)),
    volume = gsub(',', '', volume), 
    amount = gsub(',', '', amount),
    turnover = as.numeric(sub('%', '', turnover))/100,
    discount_pct = as.numeric(sub('%', '', discount_pct))
  )][grepl('\u4e07', volume), volume := as.numeric(sub('\u4e07', '', volume)) * 10^4
   ][grepl('\u4ebf', volume), volume := as.numeric(sub('\u4ebf', '', volume)) * 10^8
   ][grepl('\u4e07', amount), amount := as.numeric(sub('\u4e07', '', amount)) * 10^4
   ][grepl('\u4ebf', amount), amount := as.numeric(sub('\u4ebf', '', amount)) * 10^8] # unicode
  
  dat = merge(dat_tx[,.(date, open, high, low)], dat_1632, by = 'date', all.y=TRUE)
  dat = cbind(data.table(
    symbol = check_symbol_for_yahoo(symbol1), 
    name = md_stock_spot_tx(symbol1, only_syb_nam = T)$name
  ), dat)[, unit := 'CNY']
  
  return(dat)
}
# szse fund: 15, 16, 18
# sse fund: 50, 51, 52

