% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_founder-inbreeding.R
\name{founderInbreeding}
\alias{founderInbreeding}
\alias{founderInbreeding<-}
\title{Inbreeding coefficients of founders}
\usage{
founderInbreeding(x, ids, named = FALSE, chromType = "autosomal")

founderInbreeding(x, ids, chromType = "autosomal") <- value
}
\arguments{
\item{x}{A \code{ped} object.}

\item{ids}{Any subset of \code{founders(x)}. If \code{ids} is missing in
\code{founderInbreeding()}, it is set to \code{founders(x)}.}

\item{named}{A logical: If TRUE, the output vector is named with the ID
labels.}

\item{chromType}{Either "autosomal" (default) or "x".}

\item{value}{A numeric of the same length as \code{ids}, entries in the interval
\verb{[0, 1]}. If the vector is named, then the names are interpreted as ID
labels of the founders whose inbreeding coefficients should be set. In this
case, the \code{ids} argument should not be used. (See examples.)}
}
\value{
For \code{founderInbreeding}, a numeric vector of the same length as
\code{ids}, containing the founder inbreeding coefficients.

For \verb{founderInbreeding<-} the updated \code{ped} object is returned.
}
\description{
Functions to get or set inbreeding coefficients for the pedigree founders.
}
\examples{
x = nuclearPed(father = "fa", mother = "mo", child = 1)
founderInbreeding(x, "fa") = 1
founderInbreeding(x, named = TRUE)

# Setting all founders at once (replacement value is recycled)
founderInbreeding(x, ids = founders(x)) = 0.5
founderInbreeding(x, named = TRUE)

# Alternative syntax, using a named vector
founderInbreeding(x) = c(fa = 0.1, mo = 0.2)
founderInbreeding(x, named = TRUE)

}
