% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_plot.R
\name{plot.ped}
\alias{plot.ped}
\alias{drawPed}
\alias{plot.pedList}
\alias{plot.list}
\title{Plot pedigree}
\usage{
\method{plot}{ped}(x, draw = TRUE, keep.par = FALSE, ...)

drawPed(alignment, annotation = NULL, scaling = NULL, keep.par = FALSE, ...)

\method{plot}{pedList}(x, ...)

\method{plot}{list}(x, ...)
}
\arguments{
\item{x}{A \code{\link[=ped]{ped()}} object.}

\item{draw}{A logical, by default TRUE. If FALSE, no plot is produced, only
the plotting parameters are returned.}

\item{keep.par}{A logical, by default FALSE. If TRUE, the graphical
parameters are not reset after plotting, which may be useful for adding
additional annotation.}

\item{...}{Arguments passed on to the internal plot functions. For a complete
list of parameters, see \link{internalplot}. The most important ones are
illustrated in the Examples below.}

\item{alignment}{List of alignment details, as returned by \code{\link[=.pedAlignment]{.pedAlignment()}}.}

\item{annotation}{List of annotation details as returned by \code{\link[=.pedAnnotation]{.pedAnnotation()}}.}

\item{scaling}{List of scaling parameters as returned by \code{\link[=.pedScaling]{.pedScaling()}}.}
}
\value{
A list of three lists with various plot details: \code{alignment},
\code{annotation}, \code{scaling}.
}
\description{
This is the main function for plotting pedigrees. Many options are available
for controlling the appearance of pedigree symbols and accompanying labels.
The most important ones are illustrated in the Examples section below; for a
complete overview, see the separate page \link{internalplot}, which also explains
the plotting procedure in more detail.
}
\details{
The main pedigree layout is calculated with the \code{kinship2} package, see
\link[kinship2:align.pedigree]{kinship2::align.pedigree} for details. Unlike \code{kinship2}, the implementation
here also supports singletons, and plotting pedigrees as DAGs. In addition,
some minor adjustments have been made to improve scaling and avoid unneeded
duplications.
}
\examples{

# Singleton
plot(singleton(1))

# Trio
x = nuclearPed(father = "fa", mother = "mo", child = "boy")
plot(x)

#' # Modify margins
plot(x, margins = 6)
plot(x, margins = c(0,0,6,6)) # b,l,t,r

# Larger text and symbols
plot(x, cex = 1.5)

# Enlarge symbols only
plot(x, symbolsize = 1.5)

# Various annotations
plot(x, hatched = "boy", starred = "fa", deceased = "mo", title = "Fam 1")

# Medical pedigree
plot(x, aff = "boy", carrier = "mo")

# Label only some members
plot(x, labs = c("fa", "mo"))

# Label males only
plot(x, labs = males)

# Rename some individuals
plot(x, labs = c(FATHER = "fa", "boy"))

# By default, labels are trimmed for initial/trailing line breaks ...
plot(x, labs = c("\nFA" = "fa"))

# ... but this can be overridden
plot(x, labs = c("\nFA" = "fa"), trimLabs = FALSE)

# Colours
plot(x, col = c(fa = "red"), fill = c(mo = "green", boy = "blue"))

# Non-black hatch colours are specified with the `fill` argument
plot(x, hatched = labels, fill = c(boy = "red"))

# Use functions to specify colours
plot(x, fill = list(red = leaves, blue = ancestors(x, "boy")))

# Line type and width
plot(x, lty = 2, lwd = 3, cex = 2)

# Detailed line type and width
plot(x, lty = list(dashed = founders), lwd = c(boy = 4))

# Include genotypes
x = addMarker(x, fa = "1/1", boy = "1/2", name = "SNP")
plot(x, marker = 1)

# Markers can also be called by name
plot(x, marker = "SNP")

# Plot as DAG (directed acyclic graph)
plot(x, arrows = TRUE, title = "DAG")

# Founder inbreeding is shown by default
founderInbreeding(x, "mo") = 0.1
plot(x)

# ... but can be suppressed
plot(x, fouInb = NULL)

# Other text above and inside symbols
plot(x, textAbove = letters[1:3], textInside = LETTERS[1:3])

# Twins
x = nuclearPed(children = c("tw1", "tw2", "tw3"))
plot(x, twins = data.frame(id1 = "tw1", id2 = "tw2", code = 1)) # MZ
plot(x, twins = data.frame(id1 = "tw1", id2 = "tw2", code = 2)) # DZ

# Triplets
plot(x, twins = data.frame(id1 = c("tw1", "tw2"),
                           id2 = c("tw2", "tw3"),
                           code = 2))

# Selfing
plot(selfingPed(2))

# Complex pedigree: Quadruple half first cousins
plot(quadHalfFirstCousins())

# Straight legs
plot(quadHalfFirstCousins(), align = c(0,0))

# Use of `drawPed()`
dat = plot(nuclearPed(), draw = FALSE)
drawPed(dat$alignment, dat$annotation, dat$scaling)

}
\seealso{
\code{\link[=plotPedList]{plotPedList()}}, \code{\link[kinship2:plot.pedigree]{kinship2::plot.pedigree()}}. Plot options are
documented in \link{internalplot}.
}
