% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_getattr.R
\name{marker_getattr}
\alias{marker_getattr}
\alias{genotype}
\alias{genotype.marker}
\alias{genotype.ped}
\alias{mutmod}
\alias{mutmod.marker}
\alias{mutmod.ped}
\alias{mutmod.list}
\alias{alleles}
\alias{alleles.marker}
\alias{alleles.ped}
\alias{alleles.list}
\alias{afreq}
\alias{afreq.marker}
\alias{afreq.ped}
\alias{afreq.list}
\alias{name}
\alias{name.marker}
\alias{name.ped}
\alias{name.list}
\alias{chrom}
\alias{chrom.marker}
\alias{chrom.ped}
\alias{chrom.list}
\alias{posMb}
\alias{posMb.marker}
\alias{posMb.ped}
\title{Get marker attributes}
\usage{
genotype(x, ...)

\method{genotype}{marker}(x, id, ...)

\method{genotype}{ped}(x, markers = NULL, id, ...)

mutmod(x, ...)

\method{mutmod}{marker}(x, ...)

\method{mutmod}{ped}(x, marker, ...)

\method{mutmod}{list}(x, marker, ...)

alleles(x, ...)

\method{alleles}{marker}(x, ...)

\method{alleles}{ped}(x, marker, ...)

\method{alleles}{list}(x, marker, ...)

afreq(x, ...)

\method{afreq}{marker}(x, ...)

\method{afreq}{ped}(x, marker, ...)

\method{afreq}{list}(x, marker, ...)

name(x, ...)

\method{name}{marker}(x, ...)

\method{name}{ped}(x, markers = NULL, ...)

\method{name}{list}(x, markers = NULL, ...)

chrom(x, ...)

\method{chrom}{marker}(x, ...)

\method{chrom}{ped}(x, markers = NULL, ...)

\method{chrom}{list}(x, markers = NULL, ...)

posMb(x, ...)

\method{posMb}{marker}(x, ...)

\method{posMb}{ped}(x, markers = NULL, ...)
}
\arguments{
\item{x}{Either a \code{marker} object, a \code{ped} object or a list of \code{ped} objects.}

\item{...}{Further arguments, not used.}

\item{id}{The ID label of a single pedigree member.}

\item{marker, markers}{The index or name of a marker (or a vector indicating
several markers) attached to \code{x}.}
}
\value{
The associated marker attributes.
}
\description{
S3 methods retrieving marker attributes. They work on single marker objects
and markers attached to ped objects (or lists of such).
}
\examples{
x = nuclearPed(1)
x = addMarker(x) # add empty marker

# Inspect default attributes
alleles(x, marker = 1)
afreq(x, marker = 1)
name(x, marker = 1)  # NA
chrom(x, marker = 1) # NA

}
\seealso{
Setting marker attributes: \link{marker_setattr} and \link{marker_inplace}.
}
