% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sensitivity.R
\name{plot_sensitivity}
\alias{plot_sensitivity}
\title{Plot posterior distributions for BRMA models}
\usage{
plot_sensitivity(..., parameters = NULL, model_names = NULL)
}
\arguments{
\item{...}{Objects of class \code{brma}. If the argument \code{model_names}
is \code{NULL}, the names of these objects are used to label the plot.}

\item{parameters}{Optional character vector with the names of
parameters that exist in the models in \code{...},
Default: \code{NULL}.}

\item{model_names}{Optional character vector with the names used
to label the models in \code{...}, Default: \code{NULL}}
}
\value{
An object of class \code{ggplot}
}
\description{
To perform a rudimentary sensitivity analysis,
plot the posterior distributions of multiple BRMA models
and compare them visually.
}
\examples{
plot_sensitivity(samples = list(
data.frame(Parameter = "b",
Value = rnorm(10),
Model = "M1"),
data.frame(Parameter = "b",
Value = rnorm(10, mean = 2),
Model = "M2")),
parameters = "b")
}
