% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survpred_prcmlpmm.R
\name{survpred_prcmlpmm}
\alias{survpred_prcmlpmm}
\title{Compute the predicted survival probabilities obtained
from the PRC models}
\usage{
survpred_prcmlpmm(step2, step3, times = 1)
}
\arguments{
\item{step2}{the output of \code{\link{summarize_mlpmms}} 
(step 2 of the estimation of PRC-MLPMM)}

\item{step3}{the output of \code{\link{fit_prcmlpmm}} (step 3 
of the estimation of PRC-MLPMM)}

\item{times}{numeric vector with the time points at which
to estimate the time-dependent AUC}
}
\value{
A data frame with the predicted survival probabilities
computed at the supplied time points
}
\description{
This function computes the predictive survival probabilities 
for the for the PRC-MLPMM(U) and PRC-MLPMM(U+B) models proposed 
in Signorelli et al. (2021)
}
\examples{
data(fitted_prcmlpmm)
                   
# predict survival probabilities at times 1, 2, 3
surv.probs = survpred_prcmlpmm(fitted_prcmlpmm$step2, 
                 fitted_prcmlpmm$step3, times = 1:3)
head(surv.probs)
}
\references{
Signorelli, M., Spitali, P., Al-Khalili Szigyarto, C, 
The MARK-MD Consortium, Tsonaka, R. (2021). 
Penalized regression calibration: a method for the prediction 
of survival outcomes using complex longitudinal and 
high-dimensional data. Statistics in Medicine.
DOI: 10.1002/sim.9178
}
\seealso{
\code{\link{fit_mlpmms}} (step 1),
\code{\link{summarize_mlpmms}} (step 2) and 
\code{\link{fit_prcmlpmm}} (step 3).
}
\author{
Mirko Signorelli
}
