% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{genmodel}
\alias{genmodel}
\title{Generating Model Structure}
\usage{
genmodel(
  data,
  dep = 1,
  indep = NULL,
  fixed = NULL,
  cluster = NULL,
  selectobs = NULL
)
}
\arguments{
\item{data}{A data frame containing all relevant variables.}

\item{dep}{A string with the name of the independent variable or a column number.}

\item{indep}{A vector with the names or column numbers of the regressors. If left unspecified,
all remaining variables (excluding fixed effects) are included in the regressor matrix.}

\item{fixed}{A vector with the names or column numbers of factor variables identifying the fixed effects,
or a list with the desired interactions between variables in \code{data}.}

\item{cluster}{Optional. A string with the name of the clustering variable or a column number.
It's also possible to input a vector with several variables, in which case the interaction of
all of them is taken as the clustering variable.}

\item{selectobs}{Optional. A vector indicating which observations to use.}
}
\value{
A list with four elements:
\itemize{
\item \code{y}: y vector.
\item \code{x}: x matrix.
\item \code{fes}: list of fixed effects.
\item \code{cluster}: cluster vector.
}
}
\description{
\code{genmodel} transforms a data frame into the needed components for our main functions (a y vector,
a x matrix and a fes list).
}
