# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Faster Matrix Multiplication
#'
#' Faster matrix multiplication using C++.
#'
#' @param A,B Matrices.
eigenMatMult <- function(A, B) {
    .Call(`_penppml_eigenMatMult`, A, B)
}

#' @rdname eigenMatMult
eigenMapMatMult <- function(A, B) {
    .Call(`_penppml_eigenMapMatMult`, A, B)
}

#' Computing A'A
#'
#' Computes A'A using C++.
#'
#' @param A A matrix.
AtA <- function(A) {
    .Call(`_penppml_AtA`, A)
}

#' Faster Least Squares Estimation
#'
#' Finds Least Squares solutions using C++.
#'
#' @param X Regressor matrix.
#' @param y Dependent variable (a vector).
#'
#' @return The vector of parameter (beta) estimates.
fastolsCpp <- function(X, y) {
    .Call(`_penppml_fastolsCpp`, X, y)
}

#' Faster Ridge Regression
#'
#' Finds Ridge solutions using C++.
#'
#' @param X Regressor matrix.
#' @param y Dependent variable (a vector).
#' @param lambda Penalty parameter (a number).
#'
#' @return The vector of parameter (beta) estimates.
fastridgeCpp <- function(X, y, lambda) {
    .Call(`_penppml_fastridgeCpp`, X, y, lambda)
}

#' Faster Standard Deviation
#'
#' Computes standard deviation using C++.
#'
#' @param X Regressor matrix.
#' @param w Weights.
#'
#' @return Vector of standard deviations of the parameter estimates.
faststddev <- function(X, w) {
    .Call(`_penppml_faststddev`, X, w)
}

#' Faster Weighted Mean
#'
#' Computes weighted mean using C++.
#'
#' @param X Regressor matrix.
#' @param w Weights.
#'
#' @return Weighted mean.
fastwmean <- function(X, w) {
    .Call(`_penppml_fastwmean`, X, w)
}

#' Many Outer Products
#'
#' Compute a large number of outer products (useful for clustered SEs) using C++.
#'
#' @param A,B Numeric vectors.
#' @param c Integer.
manyouter <- function(A, B, c) {
    .Call(`_penppml_manyouter`, A, B, c)
}

#' XeeX Matrix Computation
#'
#' Given matrix ee' and matrix X, compute X(k)'ee'X(k) for each regressor X.
#'
#' @param X Regressor matrix.
#' @param e Residuals.
#' @param S Cluster sizes.
#'
#' @return The matrix product X(k)'ee'X(k).
xeex <- function(X, e, S) {
    .Call(`_penppml_xeex`, X, e, S)
}

