% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{inbuilt-actions}
\alias{inbuilt-actions}
\alias{writeToConsole}
\alias{writeToFile}
\title{Predefined(sample) handler actions}
\usage{
writeToConsole(msg, handler, ...)

writeToFile(msg, handler, ...)
}
\arguments{
\item{msg}{A formatted message to handle.}

\item{handler}{The handler environment containing its options. You can
register the same action to handlers with different properties.}

\item{...}{parameters provided by logger system to interact with the action.}
}
\description{
When you define a handler, you specify its name and the associated action.
A few predefined actions described below are provided.
}
\details{
A handler action is a function that accepts a formatted message and handler
configuration.

Messages passed are filtered already regarding loglevel.

\dots parameters are used by logging system to interact with the action. \dots can
contain \var{dry} key to inform action that it meant to initialize itself. In the case
action should return TRUE if initialization succeeded.

If it's not a dry run \dots contain the whole preformatted \var{logging.record}.
A \var{logging.record} is a named list and has following structure:
\describe{
  \item{msg}{contains the real formatted message}
  \item{level}{message level as numeric}
  \item{levelname}{message level name}
  \item{logger}{name of the logger that generated it}
  \item{timestamp}{formatted message timestamp}
}

\code{writeToConsole} detects if crayon package is available and uses it
to color messages. The coloring can be switched off by means of configuring
the handler with \var{color_output} option set to FALSE.

\code{writeToFile} action expects file path to write to under
 \var{file} key in handler options.
}
\examples{
## define your own function and register it with a handler.
## author is planning a sentry client function.  please send
## any interesting function you may have written!

}
