% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appReset.R
\name{appReset}
\alias{appReset}
\title{appReset module server function}
\usage{
appReset(id, reset_wait = 5000, alert_location = "bodyAlert", logger)
}
\arguments{
\item{id}{- Character represents the ID of the Module's UI element (the same id used in \code{appResetButton}}

\item{reset_wait}{- Integer represents the period to wait before session reload in milliseconds (default = 5000)}

\item{alert_location}{- Character represents div ID or selector to display module related messages (default = "bodyAlert")}

\item{logger}{- logger to use}
}
\value{
nothing, function will display a warning message in the app then reload the whole application
}
\description{
Server-side function for the appResetButton  This is a custom
high-functionality button for session reload. The server function is used to
 provide module configurations.
}
\section{Shiny Usage}{

This function is not called directly by consumers - it is accessed in
server_local.R (or similar file) using the same id provided in \code{appResetButton}:

\strong{\code{appReset(id = "appResetId", logger = ss_userAction.Log)}}
}

\examples{
if (interactive()) {
   library(shiny)
   library(periscope2)
   shinyApp(
     ui = fluidPage(fluidRow(column(12, appResetButton(id = "appResetId")))),
     server = function(input, output) {
       appReset(id = "appResetId", logger = "")
   })
}

}
\seealso{
\link[periscope2]{appResetButton}

\link[periscope2]{downloadFile}

\link[periscope2]{downloadFile_ValidateTypes}

\link[periscope2]{downloadFile_AvailableTypes}

\link[periscope2]{downloadablePlot}

\link[periscope2]{downloadFileButton}

\link[periscope2]{downloadableTable}

\link[periscope2]{logViewerOutput}
}
