% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_helpers.R
\name{createAlert}
\alias{createAlert}
\title{Display alert panel at specified location}
\usage{
createAlert(
  session = shiny::getDefaultReactiveDomain(),
  id = NULL,
  selector = NULL,
  options
)
}
\arguments{
\item{session}{- Shiny session object}

\item{id}{- Anchor id (either id or selector only should be set)}

\item{selector}{- Character vector represents jQuery selector to add the alert to is
(i.e ".alertClass", div.badge-danger.navbar-badge). If 'id' is specified, this parameter will be neglected}

\item{options}{- List of options to pass to the alert}
}
\value{
html div and inserts it in the app DOM
}
\description{
Create an alert panel in server code to be displayed in the specified UI selector location
}
\section{Shiny Usage}{

Call this function from \code{program/server_local.R} or any other server file to setup the needed alert
}

\examples{
  library(shiny)
  library(bs4Dash)

  # Inside server_local.R
  periscope2::createAlert(id       = "sidebarRightAlert",
                          options  = list(title    = "Right Side",
                                          status   = "success",
                                          closable = TRUE,
                                          content  = "Example Basic Sidebar Alert"))
  # Test selector
  ## a div with class "badge-danger.navbar-badge" must be exist in UI to display alert
  selector <- "div.badge-danger.navbar-badge"
  periscope2::createAlert(selector = selector,
                          options  = list(title    = "Selector Title",
                                          status   = "danger",
                                          closable = TRUE,
                                          content  = "Selector Alert"))


}
\seealso{
\link[bs4Dash:closeAlert]{bs4Dash:closeAlert()}

\link[periscope2:set_app_parameters]{periscope2:set_app_parameters()}

\link[periscope2:ui_tooltip]{periscope2:ui_tooltip()}

\link[periscope2:get_url_parameters]{periscope2:get_url_parameters()}
}
