% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_template.R
\name{create_application}
\alias{create_application}
\title{Create a new templated framework application}
\usage{
create_application(
  name,
  location,
  sample_app = FALSE,
  left_sidebar = TRUE,
  right_sidebar = FALSE
)
}
\arguments{
\item{name}{name for the new application and directory}

\item{location}{base path for creation of \code{name}}

\item{sample_app}{whether to create a sample shiny application}

\item{left_sidebar}{whether the left sidebar should be enabled. It can be TRUE/FALSE}

\item{right_sidebar}{parameter to set the right sidebar. It can be TRUE/FALSE}
}
\value{
no return value, creates application folder structure and files
}
\description{
Creates ready-to-use templated application files using the periscope2
framework. The application can be created either empty (default) or with a
sample/documented example application.\cr \cr
}
\section{Name}{

The \code{name} directory must not exist in \code{location}.  If the code
detects that this directory exists it will abort the creation process with
a warning and will not create an application template.

Use only filesystem-compatible characters in the name (ideally w/o spaces)
}

\section{Directory Structure}{


\preformatted{
name
 -- log (log files)
 -- program (user application)
 -- -- config   (application configuration files)
 -- -- data     (user application data)
 -- -- fxn      (user application function)
 -- -- modules  (application modules files)
 -- www (supporting shiny files)
 -- -- css  (application css files)
 -- -- img  (application image files)
 -- -- js   (application js files)
}
}

\section{File Information}{


All user application creation and modifications will be done in
the \strong{program} directory.  The names & locations
of the framework-provided .R files should not be changed or the framework
will fail to work as expected. \cr
\cr
\strong{\emph{name/program/config}} directory :\cr
Use this location for configuration files.\cr
\cr
\strong{\emph{name/program/data}} directory :\cr
Use this location for data files.  There is a \strong{.gitignore} file
included in this directory to prevent accidental versioning of data\cr
\cr
\strong{\emph{name/program/fxn}} directory :\cr
Use this location for supporting and helper R files.\cr
\cr
\strong{\emph{name/program/modules}} directory :\cr
Use this location for application new modules files.\cr
\cr
\strong{\emph{name/program}/global.R} :\cr
Use this location for code that would have previously resided in global.R
and for setting application parameters using
\link[periscope2]{set_app_parameters}.  Anything placed in this file will
be accessible across all user sessions as well as within the UI context. \cr
\cr
\strong{\emph{name/program}/server_global.R} :\cr
Use this location for code that would have previously resided in server.R
above (i.e. outside of) the call to \code{shinyServer(...)}. Anything placed
in this file will be accessible across all user sessions. \cr
\cr
\strong{\emph{name/program}/server_local.R} :\cr
Use this location for code that would have previously resided in server.R
inside of the call to \code{shinyServer(...)}.  Anything placed in this
file will be accessible only within a single user session.\cr
\cr
\strong{\emph{name/program}/ui_body.R} :\cr
Create body UI elements in this file and register them with the
framework using a call to \link[periscope2]{add_ui_body} \cr
\cr
\strong{\emph{name/program}/ui_footer.R} :\cr
Create footer UI elements in this file and register them with the
framework using a call to \link[periscope2]{add_ui_footer} \cr
\cr
\strong{\emph{name/program}/ui_header.R} :\cr
Create header UI elements in this file and register them with the
framework using a call to \link[periscope2]{add_ui_header} \cr
\cr
\strong{\emph{name/program}/ui_left_sidebar.R} :\cr
Create sidebar UI elements in this file and register them with the
framework using a call to \link[periscope2]{add_ui_left_sidebar} \cr
\cr
\strong{\emph{name/program}/ui_right_sidebar.R} :\cr
Create right sidebar UI elements in this file and register them with the
framework using a call to \link[periscope2]{add_ui_right_sidebar} \cr
\cr
\strong{\emph{name}/www/css/custom.css} :\cr
This is the application custom styling css file. User can update
application different parts style using this file.\cr
\cr
\strong{\emph{name}/www/js/custom.js} :\cr
This is the application custom javascript file.\cr
\cr
\strong{\emph{name}/www/periscope_style.yaml} :\cr
This is the application custom styling yaml file. User can update
application different parts style using this file.\cr
\cr
\cr
\strong{Do not modify the following files}: \cr
\preformatted{
name\\global.R
name\\server.R
name\\ui.R
name\\www\\img\\loader.gif
name\\www\\img\\tooltip.png
}
}

\examples{
# sample app named 'mytestapp' created in a temp dir
location <- tempdir()
create_application(name = 'mytestapp', location = location, sample_app = TRUE)
unlink(paste0(location,'/mytestapp'), TRUE)

# sample app named 'mytestapp' with a right sidebar using a custom icon created in a temp dir
location <- tempdir()
create_application(name = 'mytestapp', location = location, sample_app = TRUE, right_sidebar = TRUE)
unlink(paste0(location,'/mytestapp'), TRUE)

# blank app named 'myblankapp' created in a temp dir
location <- tempdir()
create_application(name = 'myblankapp', location = location)
unlink(paste0(location,'/myblankapp'), TRUE)

# blank app named 'myblankapp' without a left sidebar created in a temp dir
location <- tempdir()
create_application(name = 'myblankapp', location = location, left_sidebar = FALSE)
unlink(paste0(location,'/myblankapp'), TRUE)

}
\seealso{
\link[bs4Dash:dashboardPage]{bs4Dash:dashboardPage()}

\link[waiter:waiter]{waiter:waiter_show()}
}
