% Generated by roxygen2 (4.0.1): do not edit by hand
\name{dist.xxx}
\alias{comm.dist}
\alias{comm.dist.comparative.comm}
\alias{comm.dist.matrix}
\alias{dist.func.default}
\alias{dist.xxx}
\alias{funct.phylo.dist}
\alias{phylo.dist}
\alias{phylo.dist.comparative.comm}
\alias{phylo.dist.phylo}
\alias{pianka.dist}
\alias{pianka.dist.comparative.comm}
\alias{pianka.dist.matrix}
\alias{traits.dist}
\alias{traits.dist.comparative.comm}
\alias{traits.dist.data.frame}
\alias{traits.dist.default}
\title{Make co-existence matrices based on phylogeny (and/or) traits, and
community or environemntal overlap}
\usage{
comm.dist(x)

\method{comm.dist}{matrix}(x)

\method{comm.dist}{comparative.comm}(x)

traits.dist(x, dist.func = dist.func.default, ...)

\method{traits.dist}{comparative.comm}(x, dist.func = dist.func.default,
  alltogether = TRUE, ...)

\method{traits.dist}{default}(x, dist.func = dist.func.default, ...)

\method{traits.dist}{data.frame}(x, dist.func = dist.func.default, ...)

dist.func.default(x)

phylo.dist(x, ...)

\method{phylo.dist}{phylo}(x, ...)

\method{phylo.dist}{comparative.comm}(x, ...)

funct.phylo.dist(x, phyloWeight, p = 2, ...)

pianka.dist(x, ...)

\method{pianka.dist}{matrix}(x, env = NULL, ...)

\method{pianka.dist}{comparative.comm}(x, alltogether = TRUE, ...)
}
\arguments{
\item{x}{an object}

\item{...}{not used}

\item{dist.func}{a function for computing distances.  The default,
\code{dist.func.default}, returns a Euclidean distance of the
scaled and centred data.}

\item{alltogether}{should one multivariate distance matrix be
computed for all traits at once (DEFAULT; \code{alltogether =
TRUE}) or for each trait at a time (\code{alltogether = FALSE})?}

\item{phyloWeight}{phylogenetic weighting parameter (referred to as
\code{a} in Cadotte et al. (2013)}

\item{p}{exponent giving the exponent to use for combining
functional and phylogenetic distances (the default, \code{p = 2},
gives a Euclidean combination).}

\item{env}{environmental variable to be used to calculate the
distance matrix}
}
\description{
Make co-existence matrices based on phylogeny (and/or) traits, and
community or environemntal overlap
}
\details{
\code{comm.dist} returns the 1 - co-existence of
species. Look at how this is calcualted; it incorporates
abundances, and if you don't want it to do so simply call it on a
presence/absensence (1/0) matrix.

\code{traits.dist} returns the functional trait distance
of species

\code{phylo.dist} returns the phylogenetic (cophenetic)
distance of species

\code{funct.phylo.dist} returns the combined phylogenetic
and trait distances of species, based on the traitgram approach of
Cadotte et al. (2013).

\code{pianka.dist} returns the environemntal tolerances
distance matrices of species. Based on Pianka's distance (i.e.,
niche overlap based on environmental variables at co-occuring
sites), as defined in Cavender-Bares et al. (2004) - likely not the
original reference!
}
\references{
Cadotte M.A., Albert C.H., & Walker S.C. The ecology of differences: assessing community assembly with trait and evolutionary distances. Ecology Letters 16(10): 1234--1244.

Cavender-Bares J., Ackerly D.D., Baum D.A. & Bazzaz F.A. (2004) Phylogenetic overdispersion in Floridian oak communities. The Americant Naturalist 163(6): 823--843.
}

