% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits.R
\name{trait.asm}
\alias{trait.asm}
\title{Produces simulated communities based on species attributes}
\usage{
trait.asm(a, m = 1000, meanSR = NULL, interval = c(0.001, 10),
  exponential = TRUE, Pscale = 1)
}
\arguments{
\item{a}{species attributes (e.g., traits like body size)}

\item{m}{number of communities to be simulated}

\item{meanSR}{target mean species richness across simulated communities}

\item{interval}{adjust to obtain \code{meanSR}}

\item{exponential}{use the exponential distribution when simulating communities}

\item{Pscale}{adjust this value when not using the exponential distribution in order to scale the species richnesses in the simulated communities}
}
\value{
\code{Y} presence/absence matrix

\code{P} probabilities

\code{a} the supplied trait

\code{exponential} if the exponential distribution was used

\code{meanSR} supplied \code{meanSR} value

\code{std} estimated sd
}
\description{
\code{trait.asm} calculates phylogenetic biodiversity metrics
}
\details{
Simulates a set of communties based on the supplied attribute (trait) where larger values make it more likely for species to be in the communities.
}
\examples{
\dontrun{
 data(laja)
 trait.asm(laja$fish.pref)
}
}
\references{
Helmus M., Mercado-Silva N. & Vander Zanden M.J. (2013). Subsidies to predators, apparent competition and the phylogenetic structure of prey communities. Oecologia, 173, 997-1007.
}
\author{
M.R. Helmus
}
