/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.objects;

import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectInt;

public class PSObjectReal
extends PSObject {
    private double value;

    public PSObjectReal(String string) throws PSError {
        try {
            this.value = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSErrorTypeCheck();
        }
    }

    public PSObjectReal(double d) {
        this.value = d;
    }

    public PSObjectReal(PSObjectReal pSObjectReal) {
        this.value = pSObjectReal.value;
        this.copyCommonAttributes(pSObjectReal);
    }

    public static boolean isType(String string) {
        try {
            Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public final String isis() {
        return String.valueOf(this.value);
    }

    public final PSObjectReal abs() {
        return new PSObjectReal(Math.abs(this.value));
    }

    public final PSObject add(PSObject pSObject) throws PSErrorTypeCheck {
        double d = pSObject.toReal();
        return new PSObjectReal(this.value + d);
    }

    public final PSObject ceiling() {
        return new PSObjectReal(Math.ceil(this.value));
    }

    public PSObjectReal clone() {
        PSObjectReal pSObjectReal = (PSObjectReal)super.clone();
        return pSObjectReal;
    }

    public final int cvi() {
        try {
            return (int)this.truncate().toReal();
        }
        catch (PSErrorTypeCheck pSErrorTypeCheck) {
            return 0;
        }
    }

    public final double cvr() {
        return this.value;
    }

    public final String cvrs(int n) throws PSErrorTypeCheck, PSErrorRangeCheck {
        if (n < 2) {
            throw new PSErrorRangeCheck();
        }
        if (n == 10) {
            return Double.toString(this.value);
        }
        PSObjectInt pSObjectInt = new PSObjectInt(this.cvi());
        return pSObjectInt.cvrs(n);
    }

    public final String cvs() {
        return String.valueOf(this.value);
    }

    public final PSObjectReal dup() {
        return new PSObjectReal(this);
    }

    public final boolean eq(PSObject pSObject) {
        try {
            if (pSObject instanceof PSObjectReal || pSObject instanceof PSObjectInt) {
                return this.value == pSObject.toReal();
            }
        }
        catch (PSErrorTypeCheck pSErrorTypeCheck) {
            // empty catch block
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof PSObject) {
            return this.eq((PSObject)object);
        }
        return false;
    }

    public final PSObject floor() {
        return new PSObjectReal(Math.floor(this.value));
    }

    public final boolean gt(PSObject pSObject) throws PSErrorTypeCheck {
        return this.toReal() > pSObject.toReal();
    }

    public final int hashCode() {
        return (int)(this.value * 1000000.0);
    }

    public final PSObject mul(PSObject pSObject) throws PSErrorTypeCheck {
        double d = pSObject.toReal();
        return new PSObjectReal(this.value * d);
    }

    public final PSObjectReal neg() {
        return new PSObjectReal(-this.value);
    }

    public final PSObject round() {
        return new PSObjectReal(Math.round(this.value));
    }

    public final PSObject sub(PSObject pSObject) throws PSErrorTypeCheck {
        double d = pSObject.toReal();
        return new PSObjectReal(this.value - d);
    }

    public final String toString() {
        return "Real: " + this.value;
    }

    public final double toReal() {
        return this.value;
    }

    public final PSObject truncate() {
        if (this.value > 0.0) {
            return this.floor();
        }
        return this.ceiling();
    }

    public final String type() {
        return "realtype";
    }
}

