% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ph2rand_des.R
\name{plot.ph2rand_des}
\alias{plot.ph2rand_des}
\title{Plot the operating characteristics of a randomised clinical trial design that
assumes a Bernoulli distributed primary outcome variable}
\usage{
\method{plot}{ph2rand_des}(x, k = 1:x$J, output = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{ph2rand_des}, as returned by
\code{\link{des_one_stage}} or \code{\link{des_two_stage}}.}

\item{k}{A \code{\link{numeric}} \code{\link{vector}} indicating which stages
to consider in determining the probability mass function. That is, it will
condition the calculations on the trial ending in the stages given in
\code{k}. Defaults to \code{1:des$J} (i.e., to all stages of the given
design).}

\item{output}{A \code{\link{logical}} variable indicating whether available
outputs should be returned by the function.}

\item{...}{Not currently used.}
}
\value{
If \code{output = TRUE}, a \code{\link{list}} containing each of the
input parameters along with a \code{\link{list}} in the slot \code{$plots},
which gives all of the available produced plots.
}
\description{
\code{plot.ph2rand_des} plots the operating characteristics of a design
returned by \code{\link{des_one_stage}} or \code{\link{des_two_stage}}, under
a range of key response rate scenarios. For convenience, it also calls
\code{\link{plot.ph2rand_terminal}} to plot the terminal points of the
design.
}
\examples{
\donttest{
# The default two-stage design
des   <- des_two_stage()
# Print several key plots
plot(des)
# Determine and store all available plots
plots <- plot(des, output = TRUE)
}
}
\seealso{
\code{\link{des_one_stage}}, \code{\link{des_two_stage}},
\code{\link{plot.ph2rand_terminal}}.
}
