% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coalescent.R
\name{coalSpeciesTree}
\alias{coalSpeciesTree}
\title{Species Tree}
\usage{
coalSpeciesTree(tree, X, sTree = NULL)
}
\arguments{
\item{tree}{an object of class \code{multiPhylo}}

\item{X}{A \code{phyDat} object to define which individual belongs to which
species.}

\item{sTree}{A species tree which fixes the topology.}
}
\value{
The function returns an object of class \code{phylo}.
}
\description{
\code{coalSpeciesTree} estimates species trees and can handle multiple
individuals per species.
}
\details{
\code{coalSpeciesTree} estimates a single linkage tree as suggested by Liu
et al. (2010) from the element wise minima of the cophenetic matrices of the
gene trees. It extends \code{speciesTree} in ape as it allows that have
several individuals per gene tree.
}
\references{
Liu, L., Yu, L. and Pearl, D. K. (2010) Maximum tree: a
consistent estimator of the species tree. \emph{Journal of Mathematical
Biology}, \bold{60}, 95--106.
}
\seealso{
\code{\link{speciesTree}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com} Emmanuel Paradies
}
\keyword{cluster}
