% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{pagesize}
\alias{pagesize}
\alias{pagesize<-}
\alias{set_pagesize}
\title{Return or set pagesize}
\usage{
pagesize(x, ...)

pagesize(x) <- value

set_pagesize(x, value)
}
\arguments{
\item{x}{A \code{rtf_doc} object}

\item{...}{Additonal arguments passed to method dispatch}

\item{value}{A named numeric vector with the names \code{height} and
\code{width}.}
}
\value{
For \code{pagesize()}, the pagesize attribute of the \code{rtf_doc}
  object. For \code{`pagesize<-`()} and \code{set_pagesize()}, the modified
  object.
}
\description{
These property functions modify or return the \code{pagesize} attribute of a
\code{rtf_doc} object. Stored as a named vector with \code{height} and
\code{width} names.
}
\details{
Note that when the orientation of the document is switched
to 'portrait', the height and width will reverse when the RTF document is being
written - but the attribute values will not change. This is because the default
\code{rtf_doc} orientation is 'landscape', and switching the attributes of the
object allows for a possibility of inadvertently overriding the functionality
of the \code{orientation} attribute.
}
\examples{
library(huxtable)
ht <- huxtable(
  column1 = 1:5,
  column2 = letters[1:5]
)
rtf <- rtf_doc(ht, list(hf_line("aTitle")))

pagesize(rtf)
# Returns c(height = 8.5, width = 11.0)

pagesize(rtf) <- c(height = 12)
# Sets height of page to 12 inches

orientation(rtf) <- 'portrait'
pagesize(rtf)
#  width height
#    8.5   12.0
# Note: Despite changing orientation, attributes don't change

}
