% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{add_covariate_effect}
\alias{add_covariate_effect}
\title{add_covariate_effect}
\usage{
add_covariate_effect(
  model,
  parameter,
  covariate,
  effect,
  operation = "*",
  allow_nested = FALSE
)
}
\arguments{
\item{model}{(Model) Pharmpy model to add covariate effect to.}

\item{parameter}{(str) Name of parameter to add covariate effect to.}

\item{covariate}{(str) Name of covariate.}

\item{effect}{(str) Type of covariate effect. May be abbreviated covariate effect (see above) or custom.}

\item{operation}{(str) Whether the covariate effect should be added or multiplied (default).}

\item{allow_nested}{(logical) Whether to allow adding a covariate effect when one already exists for
the input parameter-covariate pair.}
}
\value{
(Model) Pharmpy model object
}
\description{
Adds covariate effect to :class:\code{pharmpy.model}.

The following effects have templates:
\itemize{
\item Linear function for continuous covariates (\emph{lin})
\item Function:
}

(equation could not be rendered, see API doc on website)
\itemize{
\item Init:  0.001
\item Upper:
\item If median of covariate equals minimum: 100,000
\item Otherwise: (equation could not be rendered, see API doc on website)
\item Lower:
\item If median of covariate equals maximum: -100,000
\item Otherwise: (equation could not be rendered, see API doc on website)
\item Linear function for categorical covariates (\emph{cat})
\item Function:
\item If covariate is the most common category:
}

(equation could not be rendered, see API doc on website)
\itemize{
\item For each additional category:
}

(equation could not be rendered, see API doc on website)
\itemize{
\item Init: 0.001
\item Upper: 5
\item Lower: -1
\item (alternative) Linear function for categorical covariates (\emph{cat2})
\item Function:
\item If covariate is the most common category:
}

(equation could not be rendered, see API doc on website)
\itemize{
\item For each additional category:
}

(equation could not be rendered, see API doc on website)
\itemize{
\item Init: 0.001
\item Upper: 6
\item Lower: 0
\item Piecewise linear function/"hockey-stick", continuous covariates only (\emph{piece_lin})
\item Function:
\item If cov <= median:
}

(equation could not be rendered, see API doc on website)
\itemize{
\item If cov > median:
}

(equation could not be rendered, see API doc on website)
\itemize{
\item Init: 0.001
\item Upper:
\item For first state: (equation could not be rendered, see API doc on website)
\item Otherwise: 100,000
\item Lower:
\item For first state: -100,000
\item Otherwise: (equation could not be rendered, see API doc on website)
\item Exponential function, continuous covariates only (\emph{exp})
\item Function:
}

(equation could not be rendered, see API doc on website)
\itemize{
\item Init:
\item If lower > 0.001 or upper < 0.001: (equation could not be rendered, see API doc on website)
\item If estimated init is 0: (equation could not be rendered, see API doc on website)
\item Otherwise: 0.001
\item Upper:
\item If min - median = 0 or max - median = 0: 100
\item Otherwise:
}

(equation could not be rendered, see API doc on website)
\itemize{
\item Lower:
\item If min - median = 0 or max - median = 0: 0.01
\item Otherwise:
}

(equation could not be rendered, see API doc on website)
\itemize{
\item Power function, continuous covariates only (\emph{pow})
\item Function:
}

(equation could not be rendered, see API doc on website)
\itemize{
\item Init: 0.001
\item Upper: 100,000
\item Lower: -100
}
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model <- add_covariate_effect(model, "CL", "APGR", "exp")
model$statements$before_odes$full_expression("CL")
}

}
