% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phate.R
\name{print.phate}
\alias{print.phate}
\title{Print a PHATE object}
\usage{
\method{print}{phate}(x, ...)
}
\arguments{
\item{x}{A fitted PHATE object}

\item{...}{Arguments for print()}
}
\description{
This avoids spamming the user's console with a list of many large matrices
}
\examples{
if (reticulate::py_module_available("phate")) {

# data(tree.data)
# We use a smaller tree to make examples run faster
data(tree.data.small)
phate.tree <- phate(tree.data.small$data)
print(phate.tree)
## PHATE embedding with elements
## $embedding : (3000, 2)
## $operator : Python PHATE operator
## $params : list with elements (data, k, alpha, t, n.landmark, ndim,
##                               gamma, npca, mds.method,
##                               knn.dist.method, mds.dist.method)

}
}
