% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{cluster_phate}
\alias{cluster_phate}
\title{KMeans on the PHATE potential
Clustering on the PHATE operator as introduced in Moon et al.
This is similar to spectral clustering.}
\usage{
cluster_phate(phate, k = 8, seed = NULL)
}
\arguments{
\item{phate}{\code{phate()} output}

\item{k}{Number of clusters (default: 8)}

\item{seed}{Random seed for kmeans (default: NULL)}
}
\value{
clusters Integer vector of cluster assignments
}
\description{
KMeans on the PHATE potential
Clustering on the PHATE operator as introduced in Moon et al.
This is similar to spectral clustering.
}
\examples{
if (reticulate::py_module_available("phate")) {

# Load data
# data(tree.data)
# We use a smaller tree to make examples run faster
data(tree.data.small)

# Run PHATE
phate.tree <- phate(tree.data.small$data)

# Clustering
cluster_phate(phate.tree)
}
}
