% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_midday_images.R
\name{download_midday_images}
\alias{download_midday_images}
\title{Downloading the midday images for PhenoCam sites given a time range}
\usage{
download_midday_images(site, y = year(Sys.Date()), months = 1, days = 1,
  download_dir)
}
\arguments{
\item{site}{a character string, the PhenoCam site name}

\item{y}{integer numeric, the year for which midday images are downloaded}

\item{months}{a vector of integer numeric, months for which midday images are downloaded}

\item{days}{a vector of integer numeric, days for which midday images are downloaded}

\item{download_dir}{a character string, path to directory where images are downloaded}
}
\value{
a character string, path to directory where images are downloaded
}
\description{
Downloading the midday images for PhenoCam sites given a time range
}
\examples{

download_dir <- download_midday_images('dukehw',
 y = 2018,
 months = 2,
 days=1,
 download_dir= tempdir())

}
