% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition_dates.r
\name{transition_dates}
\alias{transition_dates}
\title{Calculates transition dates for a PhenoCam time series}
\usage{
transition_dates(data, lower_thresh = 0.1, middle_thresh = 0.25,
  upper_thresh = 0.5, percentile = 90, penalty = 0.5, seg_length = 14,
  reverse = FALSE, plot = FALSE)
}
\arguments{
\item{data}{a PhenoCam data file or data structure}

\item{lower_thresh}{the minimum threshold used (default = 0.1)}

\item{middle_thresh}{the middle threshold used (default = 0.25)}

\item{upper_thresh}{the maximum threshold used (default = 0.5)}

\item{percentile}{time series percentiles to process (mean, 50, 75, 90)}

\item{penalty}{how sensitive is the algorithm, lower is more sensitve (< 0 )}

\item{seg_length}{minimum length of a segment to be evaluated}

\item{reverse}{flip the direction of the processing}

\item{plot}{plot for debugging purposes}
}
\value{
Transition date estimates in UNIX time, including uncertainties
and the threshold values estimated for each section of a time series.
}
\description{
Segments of a PhenoCam time series and calculates threshold based transition
dates for all segments. This function is rarely called stand alone and
`phenophases()` should be preferred when evaluating PhenoCam time series.
}
\examples{

\donttest{
# download demo data
download_phenocam(site = "harvard$",
                  veg_type = "DB",
                  roi_id = "1",
                  frequency = "3")

# read the data and calculate transition dates
df <- read_phenocam(paste0(tempdir(),"/harvard_DB_0001_3day.csv"))
my_dates <- transition_dates(df,
                            lower_thresh = 0.1,
                            middle_thresh = 0.25,
                            upper_thresh = 0.5,
                            percentile = 90,
                            reverse = FALSE,
                            plot = FALSE)
}
}
\keyword{PhenoCam,}
\keyword{dates,}
\keyword{phenology,}
\keyword{series}
\keyword{time}
\keyword{transition}
