% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefficients.R
\name{GOF}
\alias{GOF}
\title{GOF}
\usage{
GOF(Y_obs, Y_sim, w, include.cv = FALSE)
}
\arguments{
\item{Y_obs}{Numeric vector, observations}

\item{Y_sim}{Numeric vector, corresponding simulated values}

\item{w}{Numeric vector, weights of every points. If w included, when 
calculating mean, Bias, MAE, RMSE and NSE, w will be taken into considered.}

\item{include.cv}{If true, cv will be returned.}
}
\value{
\itemize{
\item \code{RMSE} root mean square error
\item \code{NSE} NASH coefficient
\item \code{R2} correlation of determination
\item \code{MAE} mean absolute error 
\item \code{AI} Agreement index (only good points (w == 1)) participate to 
calculate. See details in Zhang et al., (2015).
\item \code{Bias} bias
\item \code{Bias_perc} bias percentage 
\item \code{R} pearson correlation
\item \code{pvalue} pvalue of \code{R}
\item \code{n_sim} number of valid obs
\item \code{cv} Coefficient of variation
}
}
\description{
Good of fitting
}
\examples{
Y_obs = rnorm(100)
Y_sim = Y_obs + rnorm(100)/4
GOF(Y_obs, Y_sim)

}
\references{
Zhang Xiaoyang (2015), http://dx.doi.org/10.1016/j.rse.2014.10.012
}
