% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder_name.R, R/tools.R
\name{reorder_name}
\alias{reorder_name}
\alias{rm_empty}
\alias{contain}
\title{reorder_name}
\usage{
reorder_name(d, headvars = c("site", "date", "year", "doy", "d8", "d16"),
  tailvars = "")

rm_empty(x)

contain(d, pattern = "NDVI|EVI")
}
\arguments{
\item{d}{A data.frame vector, or list}

\item{headvars}{headvars will be in the head columns.}

\item{tailvars}{tailvars will be in the tail columns.}

\item{x}{A vector or list}

\item{pattern}{string used to match \code{names(d)}}
}
\description{
reorder the name of data.frame, date.table or list.
}
\examples{
df <- data.frame(year = 2010, day = 1:3, month = 1, site = "A")
dt <- data.table::data.table(year = 2010, day = 1:3, month = 1, site = "A")
l <- list(year = 2010, day = 1:3, month = 1, site = "A")

newname <- c("site", "year")
reorder_name(df, newname)
reorder_name(dt, newname)
reorder_name(l, newname)

# numeric
x <- c(1:5, NA)
rm_empty(x)

# list
l <- list(1:5, NULL, NA)
rm_empty(l)
df <- data.frame(year = 2010, day = 1:3, month = 1, site = "A")
contain(df, "year|month|day")
}
