% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curvefit.R
\name{curvefit}
\alias{curvefit}
\title{Fine curve fitting}
\usage{
curvefit(y, t = index(y), tout = t, methods = c("AG", "Beck",
  "Elmore", "Gu", "Klos", "Zhang"), ...)
}
\arguments{
\item{y}{Vegetation time-series index, numeric vector}

\item{t}{The corresponding doy of x}

\item{tout}{The output interpolated time.}

\item{methods}{Fine curve fitting methods, can be one or more of \code{c('AG',  'Beck', 'Elmore', 'Gu', 'Klos', 'Zhang')}.}

\item{...}{other parameters passed to curve fitting function.}
}
\value{
fFITs S3 object, see \code{\link[=fFITs]{fFITs()}} for details.
}
\description{
Curve fit vegetation index (VI) time-series of every growing season using
fine curve fitting methods.
}
\note{
'Klos' have too many parameters. It will be slow and not stable.
}
\examples{
library(phenofit)
# simulate vegetation time-series
fFUN = doubleLog.Beck
par  = c(
    mn  = 0.1,
    mx  = 0.7,
    sos = 50,
    rsp = 0.1,
    eos = 250,
    rau = 0.1)
t    <- seq(1, 365, 8)
tout <- seq(1, 365, 1)
y <- fFUN(par, t)

methods <- c("AG", "Beck", "Elmore", "Gu", "Zhang") # "Klos" too slow
fFITs <- curvefit(y, t, tout, methods)
}
\seealso{
\code{\link[=fFITs]{fFITs()}},
\code{\link[=FitAG]{FitAG()}}, \code{\link[=FitDL.Beck]{FitDL.Beck()}},
\code{\link[=FitDL.Elmore]{FitDL.Elmore()}}, \code{\link[=FitDL.Gu]{FitDL.Gu()}},
\code{\link[=FitDL.Klos]{FitDL.Klos()}}, \code{\link[=FitDL.Zhang]{FitDL.Zhang()}}
}
