\name{remove_site}
\alias{remove_site}
\title{Removes site information from a set of parameters.}
\usage{
  remove_site(parameters = NULL, help = FALSE)
}
\arguments{
  \item{parameters}{Set of parameters}

  \item{help}{If TRUE, an help is displayed}
}
\value{
  Return a set of modified parameters
}
\description{
  This function is used to remove the information of the
  site from a set of parameters. It can be used to other
  timeseries after.
}
\details{
  remove_site removes beach information from a set of
  parameters.
}
\examples{
library(phenology)
# Read a file with data
# Gratiot<-read.delim("http://max2.ese.u-psud.fr/epc/conservation/BI/Complete.txt", header=FALSE)
data(Gratiot)
# Generate a formatted list nammed data_Gratiot
data_Gratiot<-add_phenology(Gratiot, name="Complete", reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg<-par_init(data_Gratiot, parametersfixed=NULL)
# Run the optimisation
# result_Gratiot<-fit_phenology(data=data_Gratiot, parametersfit=parg, parametersfixed=NULL, trace=1)
data(result_Gratiot)
# Extract parameters form result
parg<-extract_result(result_Gratiot)
# Remove site information
parg1<-remove_site(parg)
}
\author{
  Marc Girondot
}

