\name{plot.phenology}
\alias{plot.phenology}
\title{Plot the phenology from a result.}
\usage{
  \method{plot}{phenology} (x, ..., data = NULL,
    parameters = NULL, parametersfixed = NA,
    series = "all", moon = FALSE, replicate.CI = 1000,
    progressbar = TRUE, help = FALSE)
}
\arguments{
  \item{x}{A result file generated by fit_phenology}

  \item{...}{Parameters used by plot}

  \item{data}{A dataset generated by add_format}

  \item{parametersfixed}{Set of fixed parameters}

  \item{parameters}{Set of parameters to be changed}

  \item{series}{Number of series to be analyzed or 'all'}

  \item{moon}{If TRUE, the moon phase is ploted. Default is
  FALSE}

  \item{replicate.CI}{Number of replicates for estimation
  of confidence interval}

  \item{progressbar}{If FALSE, do not show the progress
  bar}

  \item{help}{If TRUE, an help is displayed}
}
\value{
  Return A list of lists with formated outputs\cr For each
  site:\cr $site=name of the site\cr $estimate1=Estimation
  of counts not taking into account the observations\cr
  $sd1=The SD of estimation1\cr $estimate2=Estimation of
  counts taking into account the observations\cr $sd2=The
  SD of estimation2
}
\description{
  The function plot.phenology plots the phenology graph
  from a result object.
}
\details{
  plot.phenology plots the phenology.
}
\examples{
\dontrun{
library(phenology)
# Read a file with data
Gratiot<-read.delim("http://max2.ese.u-psud.fr/epc/conservation/BI/Complete.txt", header=FALSE)
data(Gratiot)
# Generate a formatted list nammed data_Gratiot
data_Gratiot<-add_phenology(Gratiot, name="Complete",
		reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg<-par_init(data_Gratiot, parametersfixed=NULL)
# Run the optimisation
result_Gratiot<-fit_phenology(data=data_Gratiot,
		parametersfit=parg, parametersfixed=NULL, trace=1)
data(result_Gratiot)
# Plot the phenology and get some stats
output<-plot(result_Gratiot)
# Plot only part of the nesting season
ptoutput<-plot(result_Gratiot, xlim=c(as.Date("2001-03-01"),as.Date("2001-08-31")))
# Use month names in English
Sys.setlocale(category = "LC_TIME", locale="en_GB.UTF-8")
output<-plot(result_Gratiot)
# set back the month name in local R language
Sys.setlocale(category = "LC_TIME", locale="")
}
}
\author{
  Marc Girondot
}

