% Generated by roxygen2 (4.0.2): do not edit by hand
\name{compare_AIC}
\alias{compare_AIC}
\title{Compares the AIC of several outputs}
\usage{
compare_AIC(...)
}
\arguments{
\item{...}{Successive results to be compared as lists}
}
\value{
A list with DeltaAIC and Akaike weight for the models.
}
\description{
This function is used to compares the AIC of several outputs obtained with the same data but with different set of parameters.\cr
The parameters must be lists with $aic or $AIC or $value and $par elements.\cr
If several objects are within the same list, there AIC is sumed.\cr
For example, compare_AIC(g1=list(group), g2=list(separe1, separe2)) can be used to compare a single model onto two different sets of data against each set of data fited with its own set of parameters.
}
\details{
compare_AIC compares the AIC of several outputs obtained with the same data.
}
\examples{
\dontrun{
# Read a file with data
library("phenology")
Gratiot<-read.delim("http://max2.ese.u-psud.fr/epc/conservation/BI/Complete.txt", header=FALSE)
data(Gratiot)
# Generate a formated list nammed data_Gratiot
refdate <- as.Date("2001-01-01")
data_Gratiot<-add_phenology(Gratiot, name="Complete", reference=refdate, format="\%d/\%m/\%Y")
# Fix parameter FLat to 0
pfixed=c(Flat=0)
# Generate initial points for the optimisation
parg<-par_init(data_Gratiot, parametersfixed=pfixed)
# Fit is done
result_Gratiot_Flat<-fit_phenology(data=data_Gratiot, parametersfit=parg2,
		parametersfixed=pfixed, trace=1)
data(result_Gratiot_Flat)
# Generate initial points for the optimisation
parg<-par_init(data_Gratiot, parametersfixed=NULL)
# Run the optimisation
result_Gratiot<-fit_phenology(data=data_Gratiot,
		parametersfit=parg, parametersfixed=NULL, trace=1)
data(result_Gratiot)
# Compare both models
outputAIC<-compare_AIC(full=result_Gratiot, Flat=result_Gratiot_Flat)
}
}
\author{
Marc Girondot
}

