% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tagloss_daymax.R
\name{Tagloss_daymax}
\alias{Tagloss_daymax}
\title{Return the maximum number of days an individual has been observed in a dataset.}
\usage{
Tagloss_daymax(individuals, what = "max")
}
\arguments{
\item{individuals}{Set of indivuals}

\item{what}{By default is max, but can be min, mean or all}
}
\value{
Return the maximum number of days an individual has been observed in a dataset.
}
\description{
This function must be used to get the value of mx in Tagloss_L.\cr
}
\details{
Tagloss_daymax returns the maximum number of days an individual has been observed in a dataset.
}
\examples{
\dontrun{
library(phenology)
# Example
data_f_21 <- Tagloss_format(outLR, model="21")
daymax(data_f_21)
}
}
\seealso{
Other Model of Tag-loss: \code{\link{Tagloss_LengthObs}},
  \code{\link{Tagloss_L}}, \code{\link{Tagloss_cumul}},
  \code{\link{Tagloss_fit}}, \code{\link{Tagloss_format}},
  \code{\link{Tagloss_model}},
  \code{\link{Tagloss_simulate}},
  \code{\link{logLik.Tagloss}},
  \code{\link{plot.TaglossData}},
  \code{\link{plot.Tagloss}}
}
\author{
Marc Girondot
}
\concept{Model of Tag-loss}
