% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phers.R
\name{phers}
\alias{phers}
\title{Perform multiple steps of an analysis using phenotype risk scores}
\usage{
phers(
  demos,
  icdOccurrences,
  diseasePhecodeMap,
  icdPhecodeMap = phers::icdPhecodeMap,
  dxIcd = phers::diseaseDxIcdMap,
  weights = NULL,
  residScoreFormula = NULL
)
}
\arguments{
\item{demos}{A data.table having one row per person in the cohort. Must have
a column \code{person_id}.}

\item{icdOccurrences}{A data.table of occurrences of ICD codes for each
person in the cohort. Must have columns \code{person_id}, \code{icd}, and \code{flag}.}

\item{diseasePhecodeMap}{A data.table of the mapping between diseases and
phecodes. Must have columns \code{disease_id} and \code{phecode}.}

\item{icdPhecodeMap}{A data.table of the mapping between ICD codes and
phecodes. Must have columns \code{icd}, \code{phecode}, and \code{flag}. Default is the
map included in this package.}

\item{dxIcd}{A data.table of ICD codes to exclude from mapping to phecodes.
Must have columns \code{icd} and \code{flag}. Default is the table of Mendelian
diseases and the corresponding ICD codes that indicate a genetic diagnosis.
If \code{NULL}, no ICD codes will be excluded.}

\item{weights}{A data.table of phecodes and their corresponding weights.
Must have columns \code{phecode} and \code{w}. If \code{NULL} (the default), weights will
be calculated based on data for the cohort provided. If the cohort is small
or its phecode prevalences do not reflect those in the population of
interest, it is recommended to use \link{preCalcWeights}.}

\item{residScoreFormula}{A formula representing the linear model to use for
calculating residual scores. All terms in the formula must correspond to
columns in \code{demos}. If \code{NULL}, no residual scores will be calculated.}
}
\value{
A list with elements:
\itemize{
\item \code{phecodeOccurences}: A data.table of phecode occurrences for each person
in the cohort.
\item \code{weights}: A data.table of phecodes and their corresponding weights.
\item \code{scores}: A data.table of raw and possibly residual phenotype risk scores
for each person and each disease.
}
}
\description{
This function can map ICD occurrences to phecode occurrences, calculate
weights for each phecode, and calculate raw and residual phenotype risk
scores.
}
\examples{
library('data.table')

# OMIM disease IDs for which to calculate phenotype risk scores
diseaseId = 154700

# map diseases to phecodes
diseasePhecodeMap = mapDiseaseToPhecode()
diseasePhecodeMap = diseasePhecodeMap[disease_id == diseaseId]

# calculate raw and residal scores using weights based on the sample cohort
scores = phers(
  demoSample, icdSample, diseasePhecodeMap, residScoreFormula = ~ sex)

# calculate scores using pre-calculated weights
scores = phers(
  demoSample, icdSample, diseasePhecodeMap,
  weights = phers::preCalcWeights, residScoreFormula = ~ sex)
}
\seealso{
\code{\link[=getPhecodeOccurrences]{getPhecodeOccurrences()}}, \code{\link[=getWeights]{getWeights()}}, \code{\link[=getScores]{getScores()}},
\code{\link[=getResidualScores]{getResidualScores()}}, \code{\link[=mapDiseaseToPhecode]{mapDiseaseToPhecode()}}, \link{icdPhecodeMap},
\link{diseaseDxIcdMap}, \link{preCalcWeights}, \code{\link[=getDxStatus]{getDxStatus()}}
}
