% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CE.R
\name{CE}
\alias{CE}
\title{Shannon's Conditional-Entropy \eqn{H(X | Y)}}
\usage{
CE(xy, y, unit = "log2")
}
\arguments{
\item{xy}{a numeric joint-probability vector \eqn{P(X,Y)}
for which Shannon's Joint-Entropy \eqn{H(X,Y)} shall be computed.}

\item{y}{a numeric probability vector \eqn{P(Y)} for which
Shannon's Entropy \eqn{H(Y)} (as part of the chain rule) shall be computed.
It is important to note that this probability vector must be the probability
distribution of random variable Y ( P(Y) for which H(Y) is computed).}

\item{unit}{a character string specifying the logarithm unit that shall be used to compute distances that depend on log computations.}
}
\value{
Shannon's Conditional-Entropy in bit.
}
\description{
Compute Shannon's Conditional-Entropy based on the chain rule \eqn{H(X | Y)
= H(X,Y) - H(Y)} based on a given joint-probability vector \eqn{P(X,Y)} and
probability vector \eqn{P(Y)}.
}
\details{
This function might be useful to fastly compute Shannon's
Conditional-Entropy for any given joint-probability vector and probability
vector.
}
\note{
Note that the probability vector P(Y) must be the probability
distribution of random variable Y ( P(Y) for which H(Y) is computed ) and
furthermore used for the chain rule computation of \eqn{H(X | Y) = H(X,Y) -
H(Y)}.
}
\examples{
 
 CE(1:10/sum(1:10),1:10/sum(1:10))

}
\references{
Shannon, Claude E. 1948. "A Mathematical Theory of
Communication". \emph{Bell System Technical Journal} \bold{27} (3): 379-423.
}
\seealso{
\code{\link{H}}, \code{\link{JE}}
}
\author{
Hajk-Georg Drost
}
