% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textgrid_to_df.R
\name{textgrid_to_df}
\alias{textgrid_to_df}
\title{TextGrid to dataframe}
\usage{
textgrid_to_df(file_name, encoding = "unknown", textgrids_from_folder = NULL)
}
\arguments{
\item{file_name}{string with a filename or path to the TextGrid}

\item{encoding}{TextGrid encoding. Import from \code{readLines()} function.}

\item{textgrids_from_folder}{path to a folder with multiple .TextGrid files. If this argument is not \code{NULL}, then the function goes through all files and create a merged dataframe for all of them.}
}
\value{
a dataframe with columns:  \code{id}, \code{time_start}, \code{time_end} (if it is an interval tier -- the same as the start value), \code{content}, \code{tier} and \code{source}
}
\description{
Convert Praat TextGrid to a dataframe.
}
\examples{
textgrid_to_df(system.file("extdata", "test.TextGrid", package = "phonfieldwork"))

}
\author{
George Moroz <agricolamz@gmail.com>
}
