% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{getSoluteProperties}
\alias{getSoluteProperties}
\alias{solute_properties}
\alias{getSoluteProperties.default}
\alias{getSoluteProperties.solute_spct}
\alias{getSoluteProperties.summary_solute_spct}
\alias{getSoluteProperties.solute_mspct}
\title{Get the "solute.properties" attribute}
\usage{
getSoluteProperties(x, return.null, ...)

solute_properties(x, return.null, ...)

\method{getSoluteProperties}{default}(x, return.null = FALSE, ...)

\method{getSoluteProperties}{solute_spct}(x, return.null = FALSE, ...)

\method{getSoluteProperties}{summary_solute_spct}(x, return.null = FALSE, ...)

\method{getSoluteProperties}{solute_mspct}(x, return.null = FALSE, ..., idx = "spct.idx")
}
\arguments{
\item{x}{solute_spct A spectrum of coefficients of attenuation.}

\item{return.null}{logical If true, \code{NULL} is returned if the attribute
is not set, otherwise the expected list is returned with all fields set to
\code{NA}.}

\item{...}{Allows use of additional arguments in methods for other classes.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}
}
\value{
a \code{list} with fields named \code{"mass"}, \code{"formula"},
  \code{"structure"}, \code{"name"} and \code{"ID"}. If the attribute is not
  set, and \code{return.null} is \code{FALSE}, a list with fields set to
  \code{NA} is returned, otherwise, \code{NULL}.
}
\description{
Function to read the \code{"solute.properties"} attribute of an existing
\code{solute_spct} or a \code{solute_mspct} objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default

\item \code{solute_spct}: solute_spct

\item \code{summary_solute_spct}: summary_solute_spct

\item \code{solute_mspct}: solute_mspct
}}

\note{
The method for collections of spectra returns the
  a tibble with a column of lists.
}
\examples{
solute_properties(water.spct)

}
\seealso{
Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
