% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveband.ratio.r
\name{waveband_ratio}
\alias{waveband_ratio}
\title{Photon or energy ratio}
\usage{
waveband_ratio(
  w.length,
  s.irrad,
  w.band.num = NULL,
  w.band.denom = NULL,
  unit.out.num = NULL,
  unit.out.denom = unit.out.num,
  unit.in = "energy",
  check.spectrum = TRUE,
  use.cached.mult = FALSE,
  use.hinges = getOption("photobiology.use.hinges", default = NULL)
)
}
\arguments{
\item{w.length}{numeric Vector of wavelengths [\eqn{nm}].}

\item{s.irrad}{numeric vector of spectral irradiances in
[\eqn{W\,m^{-2}\,nm^{-1}}{W m-2 nm-1}] or
[\eqn{mol\,s^{-1}\,sm^{-2}\,nm^{-1}}{mol s-1 m-2 nm-1}] as indicated by the
argument pased to \code{unit.in}.}

\item{w.band.num, w.band.denom}{waveband objects used to compute the numerator
and denominator of the ratio.}

\item{unit.out.num, unit.out.denom}{character Base of expression used to
compute the numerator and denominator of the ratio. Allowed values
\code{"energy"}, and \code{"photon"}, or its alias \code{"quantum"}.}

\item{unit.in}{character Allowed values \code{"energy"}, and \code{"photon"},
or its alias \code{"quantum"}.}

\item{check.spectrum}{logical Flag indicating whether to sanity check input
data, default is TRUE.}

\item{use.cached.mult}{logical Flag indicating whether multiplier values
should be cached between calls.}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}
}
\value{
a single numeric value giving the ratio
}
\description{
This function gives the (energy or photon) irradiance ratio between two given
wavebands of a radiation spectrum.
}
\note{
The default for both \code{w.band} parameters is a waveband covering
  the whole range of \code{w.length}. From version 0.9.19 onwards use of this
  default does not trigger a warning, but instead is used silently.
}
\examples{
# photon:photon ratio
with(sun.data,
     waveband_ratio(w.length, s.e.irrad,
                    new_waveband(400,500),
                    new_waveband(400,700), "photon"))
# energy:energy ratio
with(sun.data,
     waveband_ratio(w.length, s.e.irrad,
                    new_waveband(400,500),
                    new_waveband(400,700), "energy"))
# energy:photon ratio
with(sun.data,
     waveband_ratio(w.length, s.e.irrad,
                    new_waveband(400,700),
                    new_waveband(400,700),
                    "energy", "photon"))
# photon:photon ratio waveband : whole spectrum
with(sun.data,
     waveband_ratio(w.length, s.e.irrad,
                    new_waveband(400,500),
                    unit.out.num="photon"))
# photon:photon ratio of whole spectrum should be equal to 1.0
with(sun.data,
     waveband_ratio(w.length, s.e.irrad,
     unit.out.num="photon"))

}
