% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reflector-spct-ratios-fractions.r
\name{two_reflectances}
\alias{two_reflectances}
\title{Compute two reflectances for ratio, fraction or normalised difference}
\usage{
two_reflectances(
  spct,
  w.band.1,
  w.band.2,
  quantity,
  wb.trim,
  use.cached.mult,
  use.hinges,
  naming
)
}
\arguments{
\item{spct}{an object of class "reflector_spct" or "object_spct".}

\item{w.band.1, w.band.2}{waveband objects or lists of waveband objects
used to compute the numerator(s) and denominator(s) of the ratio(s). The
waveband(s) determine the region(s) of the spectrum that are summarized.}

\item{quantity}{character string One of "total", "average" or "mean".}

\item{wb.trim}{logical if TRUE wavebands crossing spectral data boundaries
are trimmed, if FALSE, they are discarded}

\item{use.cached.mult}{logical indicating whether multiplier values should be
cached between calls}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}

\item{naming}{character one of "long", "default", "short" or "none". Used to
select the type of names to assign to returned value.}
}
\description{
Internal function that computes the two reflectances needed to compute
various waveband ratios and fractions.
}
\details{
See \code{\link{reflectance}} for details on the reflectance calculations.
}
\keyword{internal}
