% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.reflectance.r
\name{reflectance}
\alias{reflectance}
\alias{reflectance.default}
\alias{reflectance.reflector_spct}
\alias{reflectance.object_spct}
\alias{reflectance.reflector_mspct}
\alias{reflectance.object_mspct}
\title{Reflectance}
\usage{
reflectance(spct, w.band, quantity, wb.trim, use.hinges, ...)

\method{reflectance}{default}(spct, w.band, quantity, wb.trim, use.hinges, ...)

\method{reflectance}{reflector_spct}(
  spct,
  w.band = NULL,
  quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = NULL,
  naming = "default",
  ...
)

\method{reflectance}{object_spct}(
  spct,
  w.band = NULL,
  quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = NULL,
  naming = "default",
  ...
)

\method{reflectance}{reflector_mspct}(
  spct,
  w.band = NULL,
  quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = NULL,
  naming = "default",
  ...,
  attr2tb = NULL,
  idx = "spct.idx",
  .parallel = FALSE,
  .paropts = NULL
)

\method{reflectance}{object_mspct}(
  spct,
  w.band = NULL,
  quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = NULL,
  naming = "default",
  ...,
  attr2tb = NULL,
  idx = "spct.idx",
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{spct}{an R object}

\item{w.band}{waveband or list of waveband objects or a numeric vector of
length two. The waveband(s) determine the region(s) of the spectrum that
are summarized. If a numeric range is supplied a waveband object is
constructed on the fly from it.}

\item{quantity}{character string One of \code{"average"} or \code{"mean"},
\code{"total"}, \code{"contribution"}, \code{"contribution.pc"},
\code{"relative"} or \code{"relative.pc"}.}

\item{wb.trim}{logical if \code{TRUE} wavebands crossing spectral data
boundaries are trimmed, if \code{FALSE}, they are discarded.}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}

\item{...}{other arguments}

\item{naming}{character one of \code{"long"}, \code{"default"},
\code{"short"} or \code{"none"}. Used to select the type of names to assign
to returned value.}

\item{attr2tb}{character vector, see \code{\link{add_attr2tb}} for the syntax for \code{attr2tb} passed as is to formal parameter \code{col.names}.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A named \code{numeric} vector in the case of methods for individual
  spectra, with one value for each \code{waveband} passed to parameter
  \code{w.band}. A \code{data.frame} in the case of collections of spectra,
  containing one column for each \code{waveband} object, an index column with
  the names of the spectra, and optionally additional columns with metadata
  values retrieved from the attributes of the member spectra.

  By default values are only integrated, but depending on the argument passed
  to parameter \code{quantity} they can be re-expressed as relative fractions
  or percentages. In the case of vector output, \code{names} attribute is set
  to the name of the corresponding waveband unless a named list is supplied
  in which case the names of the list members are used.
}
\description{
Function to calculate the mean, total, or other summary of reflectance for
spectral data stored in a \code{reflector_spct} or in an \code{object_spct}.
}
\section{Methods (by class)}{
\itemize{
\item \code{reflectance(default)}: Default for generic function

\item \code{reflectance(reflector_spct)}: Specialization for reflector_spct

\item \code{reflectance(object_spct)}: Specialization for object_spct

\item \code{reflectance(reflector_mspct)}: Calculates reflectance from a \code{reflector_mspct}

\item \code{reflectance(object_mspct)}: Calculates reflectance from a \code{object_mspct}

}}
\note{
The \code{use.hinges} parameter controls speed optimization. The
  defaults should be suitable in most cases. Only the range of wavelengths
  in the wavebands is used and all BSWFs are ignored.
}
\examples{
reflectance(black_body.spct, waveband(c(400,700)))
reflectance(white_body.spct, waveband(c(400,700)))

}
