% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.smooth.spct.R
\name{smooth_spct}
\alias{smooth_spct}
\alias{smooth_spct.default}
\alias{smooth_spct.source_spct}
\alias{smooth_spct.filter_spct}
\alias{smooth_spct.reflector_spct}
\alias{smooth_spct.response_spct}
\title{Smooth a spectrum}
\usage{
smooth_spct(x, method, strength, ...)

\method{smooth_spct}{default}(x, method, strength, ...)

\method{smooth_spct}{source_spct}(x, method = "custom", strength = 1, ...)

\method{smooth_spct}{filter_spct}(x, method = "custom", strength = 1, ...)

\method{smooth_spct}{reflector_spct}(x, method = "custom", strength = 1,
  ...)

\method{smooth_spct}{response_spct}(x, method = "custom", strength = 1, ...)
}
\arguments{
\item{x}{an R object}

\item{method}{a character string "custom", "lowess", "supsmu"}

\item{strength}{numeric value to adjust the degree of smoothing}

\item{...}{other parameters passed to the underlying smoothing functions}
}
\description{
These functions implement one original methods and acts as a wrapper for
other common R smoothing functions. The advantage of using this function for
smoothing spectral objects is that it simplifies the user interface and sets,
when needed, defaults suitable for spectral data.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{source_spct}: Smooth a source spectrum

\item \code{filter_spct}: Smooth a filter spectrum

\item \code{reflector_spct}: Smooth a reflector spectrum

\item \code{response_spct}: Smooth a response spectrum
}}

\note{
Method "custom" is our home-brewed method which applies strong
  smoothing to low signal regions of the spectral data, and weaker or no
  smoothing to the high signal areas. Values very close to zero are set to
  zero with a limit which depends on the local variation. This method is an
  ad-hock method suitable for smoothing spectral data obtained with array
  spectrometers. In the cased of methods "lowess" and "supsmu" the current
  function behaves like a wrapper of the functions of the same names from
  base R.
}
