% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sun.data.R
\docType{data}
\name{sun.daily.data}
\alias{sun.daily.data}
\title{Daily solar spectral irradiance (simulated)}
\format{A \code{data.frame} object with 511 rows and 3 variables}
\usage{
sun.daily.data
}
\description{
A dataset containing the wavelengths at a 1 nm interval and the corresponding
spectral (energy) irradiance. Values simulated for 2 June 2012, at Helsinki,
under clear sky conditions. The variables are as follows:
}
\details{
\itemize{ \item w.length (nm), range 290 to 800 nm. \item s.e.irrad (J d-1
m-2 nm-1) \item s.q.irrad (mol d-1 m-2 nm-1) }
}
\examples{
sun.daily.spct

}
\references{
Lindfors, A.; Heikkilä, A.; Kaurola, J.; Koskela, T. & Lakkala,
K. (2009) Reconstruction of Solar Spectral Surface UV Irradiances Using
Radiative Transfer Simulations. Photochemistry and Photobiology, 85:
1233–1239
}
\seealso{
Other Spectral data examples: \code{\link{A.illuminant.spct}},
  \code{\link{D65.illuminant.spct}},
  \code{\link{Ler_leaf.spct}},
  \code{\link{Ler_leaf_rflt.spct}},
  \code{\link{Ler_leaf_trns.spct}},
  \code{\link{Ler_leaf_trns_i.spct}},
  \code{\link{black_body.spct}}, \code{\link{ccd.spct}},
  \code{\link{clear.spct}}, \code{\link{clear_body.spct}},
  \code{\link{filter_cps.mspct}},
  \code{\link{green_leaf.spct}}, \code{\link{opaque.spct}},
  \code{\link{photodiode.spct}},
  \code{\link{polyester.spct}},
  \code{\link{sun.daily.spct}}, \code{\link{sun.data}},
  \code{\link{sun.spct}}, \code{\link{white_body.spct}},
  \code{\link{white_led.cps_spct}},
  \code{\link{white_led.raw_spct}},
  \code{\link{white_led.source_spct}},
  \code{\link{yellow_gel.spct}}
}
\author{
Anders K. Lindfors (data)
}
\keyword{datasets}
